% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_gridmap.R
\name{esp_get_gridmap}
\alias{esp_get_gridmap}
\alias{esp_get_hex_prov}
\alias{esp_get_hex_ccaa}
\alias{esp_get_grid_prov}
\alias{esp_get_grid_ccaa}
\title{Get a \code{sf} hexbin or squared polygon of Spain}
\usage{
esp_get_hex_prov(prov = NULL)

esp_get_hex_ccaa(ccaa = NULL)

esp_get_grid_prov(prov = NULL)

esp_get_grid_ccaa(ccaa = NULL)
}
\arguments{
\item{prov}{A vector of names and/or codes for provinces
or \code{NULL} to get all the provinces. See \strong{Details}.}

\item{ccaa}{A vector of names and/or codes for autonomous communities
or \code{NULL} to get all the autonomous communities. See \strong{Details}.}
}
\value{
A \code{sf} POLYGON object.
}
\description{
Loads a hexbin map (\code{sf} object) or a map of squares with the boundaries of
the provinces or autonomous communities of Spain.
}
\details{
Hexbin or grid map has an advantage over usual choropleth maps.
In choropleths, a large polygon data looks more emphasized just because
of its size, what introduces a bias. Here with hexbin, each region is
represented equally dismissing the bias.

You can use and mix names, ISO codes, "codauto"/"cpro" codes (see
\link{esp_codelist}) and NUTS codes of different levels.

When using a code corresponding of a higher level (e.g.
\code{esp_get_prov("Andalucia")}) all the corresponding units of that level are
provided (in this case , all the provinces of Andalucia).

Results are provided in \strong{EPSG:4258}, use \code{\link[sf:st_transform]{sf::st_transform()}}
to change the projection.
}
\examples{


esp <- esp_get_country()
hexccaa <- esp_get_hex_ccaa()

library(ggplot2)

ggplot(hexccaa) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto),
    alpha = 0.3,
    show.legend = FALSE
  ) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Hexbin: CCAA")





hexprov <- esp_get_hex_prov()

ggplot(hexprov) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto),
    alpha = 0.3,
    show.legend = FALSE
  ) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Hexbin: Provinces")



gridccaa <- esp_get_grid_ccaa()

ggplot(gridccaa) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto),
    alpha = 0.3,
    show.legend = FALSE
  ) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Grid: CCAA")


gridprov <- esp_get_grid_prov()

ggplot(gridprov) +
  geom_sf(data = esp) +
  geom_sf(aes(fill = codauto),
    alpha = 0.3,
    show.legend = FALSE
  ) +
  geom_sf_text(aes(label = label), check_overlap = TRUE) +
  theme_void() +
  labs(title = "Grid: Provinces")
}
\seealso{
Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_simpl_prov}()}
}
\concept{political}
