% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_roads.R
\name{esp_get_roads}
\alias{esp_get_roads}
\title{Get the roads of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_roads(
  year = Sys.Date(),
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  moveCAN = TRUE
)
}
\arguments{
\item{year}{Release year. See Details for years available.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with \code{options(mapSpain_cache_dir = "path/to/dir")}.
See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates.}
}
\value{
A \verb{LINESTRING\\MULTILINESTRING} object.
}
\description{
Get roads of Spain
}
\details{
\code{year} could be passed as a single year ("YYYY" format, as end of year) or
as a specific date ("YYYY-MM-DD" format).

Details on caching can be found on \code{\link[=esp_get_nuts]{esp_get_nuts()}}
}
\note{
While \code{moveCAN} is useful for visualization, it would alter the
actual geographical position of the Canary Islands.
}
\examples{
\donttest{
library(sf)
library(cartography)

CyL <- esp_get_prov("Castilla y Leon")
Roads <- esp_get_roads()

# Intersect roads
CyL_Roads <- st_intersection(CyL, Roads)

plot(st_geometry(CyL), col = "grey80", border = "grey50", lwd = 0.4)
typoLayer(CyL_Roads,
  var = "tipo",
  col = c("#003399", "#003399", "#ff0000", "#ffff00"),
  lwd = 2,
  add = TRUE,
  legend.pos = "n"
)
}
}
\seealso{
\code{\link[=esp_get_munic]{esp_get_munic()}}, \link{esp_munic.sf}, \link{esp_codelist}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}.
}
\concept{infrastructure}
