% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_model_info.R
\name{extract_model_info}
\alias{extract_model_info}
\title{Extract important model attributes}
\usage{
extract_model_info(model_object = NULL, what = NULL, ...)
}
\arguments{
\item{model_object}{A model object for example a linear model object, generalized linear model object,
analysis of variance object.}

\item{what}{character. The attribute you would like to obtain for instance p_value}

\item{...}{Arguments to other functions e.g. AIC, BIC, deviance etc}
}
\description{
Provides a convenient way to extract any kind of model information from
common model objects
}
\details{
This provides a convenient way to extract model information for any kind of model. For linear models,
one can extract such attributes as coefficients, p value("p_value"), standard error("std_err"),
estimate, t value("t_value"), residuals, aic and other known attributes.
For analysis of variance (aov), other attributes like sum squared(ssq),
mean squared error(msq), degrees of freedom(df),p_value.
}
\examples{
# perform analysis of variance
data("yields", package="manymodelr")
aov_mod <- fit_model(yields, "weight","height + normal","aov")
extract_model_info(aov_mod, "ssq")
extract_model_info(aov_mod, c("ssq","predictors")) 
# linear regression
lm_model <-fit_model(yields, "weight","height","lm")
extract_model_info(lm_model,c("aic","bic"))
## glm
glm_model <- fit_model(yields, "weight","height","glm")
extract_model_info(glm_model,"aic")
}
