% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wwtp_functions.R
\name{wwtp_classify_sources}
\alias{wwtp_classify_sources}
\title{Classify WWTP Sources by Load Size}
\usage{
wwtp_classify_sources(wwtp_data, nutrient)
}
\arguments{
\item{wwtp_data}{Data frame. WWTP data with load information}

\item{nutrient}{Character. "nitrogen" or "phosphorus"}
}
\value{
Data frame with source_class column added
}
\description{
Classify WWTP facilities into size categories based on annual nutrient loads
}
\examples{
\donttest{
# Load WWTP data first
wwtp_data <- load_builtin_wwtp("nitrogen", 2016)

# Classify nitrogen sources
classified_data <- wwtp_classify_sources(wwtp_data, "nitrogen")
table(classified_data$source_class)
}
}
