% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert.R
\name{mantis_alerts}
\alias{mantis_alerts}
\title{Generate a data frame containing alert results}
\usage{
mantis_alerts(
  df,
  inputspec,
  alert_rules,
  filter_results = c("PASS", "FAIL", "NA"),
  timepoint_limits = c(NA, NA),
  fill_with_zero = FALSE
)
}
\arguments{
\item{df}{A data frame containing multiple time series in long format. See
Details.}

\item{inputspec}{\code{\link[=inputspec]{inputspec()}} object specifying which columns in the
supplied \code{df} represent the "timepoint", "item", and "value" for the time
series.}

\item{alert_rules}{\code{\link[=alert_rules]{alert_rules()}} object specifying conditions to test}

\item{filter_results}{Only return rows where the alert result is in this
vector of values. Alert results can be "PASS", "FAIL", or "NA".}

\item{timepoint_limits}{Set start and end dates for time period to include.
Defaults to min/max of \code{timepoint_col}. Can be either Date values or NAs.}

\item{fill_with_zero}{Logical. Replace any missing or NA values with 0?
Useful when value_col is a record count.}
}
\value{
tibble
}
\description{
Test the time series for a set of conditions without generating an html
report. This can be useful for incorporation into a pipeline.
}
\details{
The supplied data frame should contain multiple time series in long
format, i.e.:
\itemize{
\item one "timepoint" (date/posixt) column which will be used for the x-axes.
Values should follow a regular pattern, e.g. daily or monthly, but do not
have to be consecutive.
\item one or more "item" (character) columns containing categorical values
identifying distinct time series.
\item one "value" (numeric) column containing the time series values which will
be used for the y-axes.
}

The \code{inputspec} parameter maps the data frame columns to the above.
}
\examples{
alert_results <- mantis_alerts(
  example_prescription_numbers,
  inputspec = inputspec(
    timepoint_col = "PrescriptionDate",
    item_cols = c("Antibiotic", "Location"),
    value_col = "NumberOfPrescriptions"
  ),
  alert_rules = alert_rules(
    alert_missing(extent_type = "any", extent_value = 1),
    alert_equals(extent_type = "all", rule_value = 0)
  )
)

}
\seealso{
\code{\link[=alert_rules]{alert_rules()}}, \code{\link[=inputspec]{inputspec()}}, \code{\link[=alert_rule_types]{alert_rule_types()}}
}
