#Copyright © 2016 RTE Réseau de transport d’électricité

#' Generate controls UI of a manipulateWidget gadget
#'
#' This function can be used if you want to create a custom UI for your gadget
#' but desire to use the controls generated by function \code{manipulateWidget}
#'
#' @param .dir
#'   In which direction should the controls be positioned ? "v" for vertical
#'   and "h" for horizontal.
#' @param .n
#'   Number of columns if \code{.dir == "v"} else number of lines.
#' @inheritParams manipulateWidget
#'
#' @return
#'   A \code{shiny.tag.list} that can be used to construct a UI for a shiny
#'   gadget.
#'
#' @export
#'
mwControlsUI <- function(..., .dir = c("v", "h"), .n = 1, .updateBtn = FALSE) {
  .dir <- match.arg(.dir)

  controls <- list(...)
  ids <- names(controls)

  controls <- mapply(
    function(f, id) {
      if(is.list(f)) {
        ctrls <- do.call(mwControlsUI, f)
        id <- gsub(" ", "-", id)
        res <- tags$div(
          class="panel panel-default",
          tags$div(
            class="panel-heading",
            style = "cursor: pointer;",
            "data-toggle"="collapse",
            "data-target"=paste0("#panel-body-", id),
            id
          ),
          tags$div(
            class="panel-body collapse",
            id=paste0("panel-body-", id),
            ctrls
          )
        )

        attr(res, "controlNames") <- .getControlNames(ctrls)

      } else {
        res <- conditionalPanel(
          condition = sprintf("input.%s_visible", id),
          f(id, width = ifelse(.dir == "v", "100%", "180px"))
        )

        attr(res, "controlNames") <- id
      }

      res
    },
    f = controls, id = ids,
    SIMPLIFY = FALSE, USE.NAMES = FALSE
  )

  vis_checkboxes <- lapply(ids, function(id) {
    checkboxInput(paste0(id, "_visible"), "", value = TRUE)
  })
  vis_checkboxes$style <- "display:none"

  controls <- append(controls, list(do.call(tags$div, vis_checkboxes)))

  if (.updateBtn) controls <- append(controls, list(actionButton(".update", "Update",
                                                                 class = "btn-primary")))


  if (.dir == "v") {
    if (.n == 1) res <- .controlsCol(controls)
    else {
      nrows <- ceiling(length(controls) / .n)
      controlCols <- lapply(1:.n, function(i) {
        .controlsCol(controls[((i-1) * nrows + 1):(i * nrows)])
      })
      res <- do.call(fillRow, controlCols)
    }

  } else { # dir == "h"
    if (.n == 1) res <- .controlsRow(controls)
    else {
      ncols <- ceiling(length(controls) / .n)
      controlRows <- lapply(1:.n, function(i) {
        .controlsRow(controls[((i-1) * ncols + 1):(i * ncols)])
      })
      res <- do.call(fillCol, controlRows)
    }
  }

  attr(res, "controlNames") <- .getControlNames(controls)
  res
}

.controlsCol <- function(controls) {
  #controls$style <- "width:200px;"
  do.call(div, controls)
}

.controlsRow <- function(controls) {
  controls$height <- "100px"
  do.call(fillRow, controls)
}

.getControlNames <- function(x) {
  if (!is.null(attr(x, "controlNames"))) return(attr(x, "controlNames"))
  unlist(lapply(x, function(e) attr(e, "controlNames")))
}

