% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifesto.R
\name{mp_maindataset}
\alias{mp_maindataset}
\alias{mp_southamerica_dataset}
\title{Access the Manifesto Project's Main Dataset}
\usage{
mp_maindataset(version = "current", south_america = FALSE,
  download_format = NULL, apikey = NULL, cache = TRUE)

mp_southamerica_dataset(...)
}
\arguments{
\item{version}{Specify the version of the dataset you want to access. Use
"current" to obtain the most recent, or use
\code{\link{mp_coreversions}} for a list of available
versions.}

\item{south_america}{flag whether to download corresponding South America dataset instead of Main Dataset}

\item{download_format}{Download format. If not NULL, instead of the dataset
being returned as an R data.frame, a file path to a temporary file in the specified
binary format is returned. Can be one of \code{c("dta", "xlsx", "sav")}. With
the "dta" option, labeled columns can be obtained.}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Boolean flag indicating whether to use locally cached data if
available.}

\item{...}{all arguments of \code{mp_southamerica_data} are passed on to \code{mp_maindataset}}
}
\value{
The Manifesto Project Main Dataset with classes \code{data.frame} and
\code{\link[dplyr]{tbl_df}}
}
\description{
Gets the Manifesto Project's Main Dataset from the project's web API or
the local cache, if it was already downloaded before.
}
\details{
\code{mp_southamerica_dataset} is a shorthand for getting the Manifesto
Project's South America Dataset (it is equivalent to 
\code{mp_maindataset(..., south_america = TRUE)}).
}
\examples{
\dontrun{
mpds <- mp_maindataset()
head(mpds)
median(subset(mpds, countryname == "Switzerland")$rile, na.rm = TRUE)
}
\dontrun{
mp_maindataset(download_format = "dta") \%>\% read_dta() ## requires package haven
}
}
