% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sample_geneology}
\alias{sample_geneology}
\title{Simulate a geneology with constant population size.}
\usage{
sample_geneology(
  population_size,
  generations,
  generations_full = 1L,
  generations_return = 3L,
  enable_gamma_variance_extension = FALSE,
  gamma_parameter_shape = 5,
  gamma_parameter_scale = 1/5,
  progress = TRUE,
  verbose_result = FALSE
)
}
\arguments{
\item{population_size}{The size of the population.}

\item{generations}{The number of generations to simulate:
\itemize{
\item -1 for simulate to 1 founder
\item else simulate this number of generations.
}}

\item{generations_full}{Number of full generations to be simulated.}

\item{generations_return}{How many generations to return (pointers to) individuals for.}

\item{enable_gamma_variance_extension}{Enable symmetric Dirichlet (and disable standard Wright-Fisher).}

\item{gamma_parameter_shape}{Parameter related to symmetric Dirichlet distribution for each man's probability to be father. Refer to details.}

\item{gamma_parameter_scale}{Parameter realted to symmetric Dirichlet distribution for each man's probability to be father. Refer to details.}

\item{progress}{Show progress.}

\item{verbose_result}{Verbose result.}
}
\value{
A malan_simulation / list with the following entries:
\itemize{
\item \code{population}. An external pointer to the population.
\item \code{generations}. Generations actually simulated, mostly useful when parameter \code{generations = -1}.
\item \code{founders}. Number of founders after the simulated \code{generations}.
\item \code{growth_type}. Growth type model.
\item \code{sdo_type}. Standard deviation in a man's number of male offspring. StandardWF or GammaVariation depending on \code{enable_gamma_variance_extension}.
\item \code{end_generation_individuals}. Pointers to individuals in end generation.
\item \code{individuals_generations}. Pointers to individuals in last \code{generations_return} generation (if \code{generations_return = 3}, then individuals in the last three generations are returned).
}
If \code{verbose_result} is true, then these additional components are also returned:
\itemize{
\item \code{individual_pids}. A matrix with pid (person id) for each individual.
\item \code{father_pids}. A matrix with pid (person id) for each individual's father.
\item \code{father_indices}. A matrix with indices for fathers.
}
}
\description{
This function simulates a geneology where the last generation has \code{population_size} individuals.
}
\details{
By the backwards simulating process of the Wright-Fisher model,
individuals with no descendants in the end population are not simulated.
If for some reason additional full generations should be simulated,
the number can be specified via the \code{generations_full} parameter.
This can for example be useful if one wants to simulate the
final 3 generations although some of these may not get (male) children.

Let \eqn{\alpha} be the parameter of a symmetric Dirichlet distribution
specifying each man's probability to be the father of an arbitrary
male in the next generation. When \eqn{\alpha = 5}, a man's relative probability
to be the father has 95\\% probability to lie between 0.32 and 2.05, compared with a
constant 1 under the standard Wright-Fisher model and the standard deviation in
the number of male offspring per man is 1.10 (standard Wright-Fisher = 1).

This symmetric Dirichlet distribution is implemented by drawing
father (unscaled) probabilities from a Gamma distribution with
parameters \code{gamma_parameter_shape} and \code{gamma_parameter_scale}
that are then normalised to sum to 1.
To obtain a symmetric Dirichlet distribution with parameter \eqn{\alpha},
the following must be used:
\eqn{`gamma_parameter_shape` = \alpha}
and
\eqn{`gamma_parameter_scale` = 1/\alpha}.
}
\examples{
sim <- sample_geneology(100, 10)
str(sim, 1)
sim$population
peds <- build_pedigrees(sim$population)
peds

}
\seealso{
\code{\link[=sample_geneology_varying_size]{sample_geneology_varying_size()}}.
}
