% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makedummies.R
\name{makedummies}
\alias{makedummies}
\alias{makedummies.default}
\alias{makedummies.matrix}
\alias{makedummies.tbl}
\title{Create Dummy Variables from Categorical Data}
\usage{
makedummies(dat, ...)

\method{makedummies}{default}(dat, basal_level = FALSE, col = NULL,
  numerical = NULL, as.is = NULL, ...)

\method{makedummies}{matrix}(dat, ...)

\method{makedummies}{tbl}(dat, ...)
}
\arguments{
\item{dat}{data of \code{data.frame}, \code{matrix},
or \code{tbl} class}

\item{\dots}{arguments to makedummies.data.frame (\code{tbl} class)}

\item{basal_level}{logical
\describe{
 \item{TRUE}{: include a dummy variable for base group}
 \item{FALSE}{(default) : exclude a dummy variable for base group}
}}

\item{col}{Columns vector (all columns are used if \code{NULL} is given)}

\item{numerical}{Columns vector converting from \code{factor/ordered} to \code{numeric} (ignore if column is \code{numeric})}

\item{as.is}{Columns vector not converting}
}
\value{
return as \code{data.frame} or \code{tbl} class
}
\description{
Create dummy variables from categorical data.
This package can convert categorical data (factor and ordered) into
dummy variables and handle multiple columns simultaneously.
This package enables to select whether a dummy variable for base group
is included (for principal component analysis/factor analysis) or
excluded (for regression analysis) by an option.
\code{makedummies} function accepts
\code{data.frame}, \code{matrix}, and
\code{tbl} (tibble) class (by \code{tibble} package).
\code{matrix} class data is automatically converted to
\code{data.frame} class.
}
\note{
Pull Request #1 (add column name when when columns has binary value) (\url{https://github.com/toshi-ara/makedummies/pull/1}). Thanks to Kohki YAMAGIWA for the contribution.
}
\examples{
#### 'data.frame' class
## factor
dat <- data.frame(x = factor(rep(c("a", "b", "c"), each = 3)))
dat$x
makedummies(dat)

## ordered
dat <- data.frame(x = factor(rep(c("a", "b", "c"), each = 3)))
dat$x <- ordered(dat$x, levels = c("a" ,"c" ,"b"))
dat$x
makedummies(dat)

## numeric
dat <- data.frame(x = rep(1:3, each = 3))
makedummies(dat)

## factor and numeric
dat <- data.frame(
    x = factor(rep(c("a", "b", "c"), each = 3)),
    y = rep(1:3, each = 3)
)
makedummies(dat)

## factors
dat <- data.frame(
x = factor(rep(c("a", "b", "c"), each = 3)),
y = factor(rep(1:3, each = 3))
)
makedummies(dat)

## "col" option
dat <- data.frame(
    x = factor(rep(c("a", "b", "c"), each = 3)),
    y = factor(rep(1:3, each = 3))
)
makedummies(dat, col = "x")

## "numerical" option
dat <- data.frame(
    x = factor(rep(c("a", "b", "c"), each = 3)),
    y = factor(rep(1:3, each = 3))
)
makedummies(dat, numeric = "x")

dat <- data.frame(
    x = factor(rep(c("a", "b", "c"), each = 3)),
    y = rep(4:6, each = 3)
)
dat$x <- ordered(dat$x, levels = c("a" ,"c" ,"b"))
dat
dat$x
makedummies(dat, numeric = c("x", "y"))

## "as.is" option
dat <- data.frame(
    x = factor(rep(c("a", "b", "c"), each = 3)),
    y = factor(rep(1:3, each = 3))
)
dat
makedummies(dat, as.is = "x")
makedummies(dat, as.is = c("x", "y"))

#### 'tibble' class
if (require(tibble)) {
  dat <- as_tibble(iris)
  makedummies(dat[46:55,], col = "Species", basal_level = TRUE)
}

}
