testthat::context("parallel tempering")
testthat::test_that("parallel tempering runs without error", {
  ret <- magi:::paralleltemperingTest1()
  testthat::expect_equal(dim(ret), c(5, 8, 10000))

  temperature <- 8:1
  for(id in 1:8){
    mydist <- function(x) pnorm(x, sd=sqrt(temperature[id]))
    # FIXME seems to have significant bias -- may due to poorly tuned sampler
    # disable test for now
    # testthat::expect_gt(ks.test(ret[-1,id,], "mydist"), 1e-6)
  }
  layout(matrix(1:4, 2))
  for(id in 1:8){
    hist(ret[2,id,], probability = T)
    plot.function(function(x)
      dnorm(x, sd=sqrt(temperature[id])), 
      from=-20,to=20,col=2,add=T, n=1001)
    hist(ret[3,id,], probability = T)
    plot.function(function(x)
      dnorm(x, sd=sqrt(temperature[id])), 
      from=-20,to=20,col=2,add=T, n=1001)
    hist(ret[4,id,], probability = T)
    plot.function(function(x)
      dnorm(x, sd=sqrt(temperature[id])), 
      from=-20,to=20,col=2,add=T, n=1001)
    hist(ret[5,id,], probability = T)
    plot.function(function(x)
      dnorm(x, sd=sqrt(temperature[id])), 
      from=-20,to=20,col=2,add=T, n=1001)
  }
  
  ret <- magi:::paralleltemperingTest2()
  temperature <- c(1, 1.3, 1.8, 2.5, 3.8, 5.7, 8) 
  
  for(id in 1:8){
    mydist <- function(x) (pnorm(x, -4, sd=temperature[id]) + dnorm(x, 4, sd=temperature[id]))/2
    # FIXME seems to have significant bias -- may due to poorly tuned sampler
    # disable test for now
    # testthat::expect_gt(ks.test(ret[-1,id,], "mydist"), 1e-6)
  }
  
  layout(matrix(1:4, 2))
  for(id in 1:length(temperature)){
    hist(ret[2,id,], probability = T)
    plot.function(function(x)
      (dnorm(x, -4, sd=temperature[id]) + dnorm(x, 4, sd=temperature[id]))/2, 
      from=-20,to=20,col=2,add=T, n=1001)
    hist(ret[3,id,], probability = T)
    plot.function(function(x)
      (dnorm(x, -4, sd=temperature[id]) + dnorm(x, 4, sd=temperature[id]))/2, 
      from=-20,to=20,col=2,add=T, n=1001)
    hist(ret[4,id,], probability = T)
    plot.function(function(x)
      (dnorm(x, -4, sd=temperature[id]) + dnorm(x, 4, sd=temperature[id]))/2, 
      from=-20,to=20,col=2,add=T, n=1001)
    hist(ret[5,id,], probability = T)
    plot.function(function(x)
      (dnorm(x, -4, sd=temperature[id]) + dnorm(x, 4, sd=temperature[id]))/2, 
      from=-20,to=20,col=2,add=T, n=1001)
  }
  testthat::expect_equal(dim(ret), c(5, 7, 10000))
})

testthat::test_that("parallel_temper_hmc_xtheta runs without error", {
  
  config <- list(
    nobs = 41,
    noise = 0.1,
    kernel = "generalMatern",
    seed = 123,
    npostplot = 5,
    loglikflag = "band",
    bandsize = 20,
    hmcSteps = 20,
    n.iter = 3e2,
    burninRatio = 0.1,
    stepSizeFactor = 1
  )
  
  VRtrue <- read.csv(system.file("testdata/FN.csv", package="magi"))
  pram.true <- list(
    abc=c(0.2,0.2,3),
    rphi=c(0.9486433, 3.2682434),
    vphi=c(1.9840824, 1.1185157),
    sigma=config$noise
  )
  fn.true <- VRtrue[seq(1,401,by=2),]   #### reference is 201 points
  fn.true$time <- seq(0,20,0.1)
  fn.sim <- fn.true
  
  set.seed(config$seed)
  fn.sim[,1:2] <- fn.sim[,1:2]+rnorm(length(unlist(fn.sim[,1:2])), sd=config$noise)
  tvec.full <- fn.sim$time
  fn.sim.all <- fn.sim
  fn.sim[-seq(1,nrow(fn.sim), length=config$nobs),] <- NaN
  fn.sim.obs <- fn.sim[seq(1,nrow(fn.sim), length=config$nobs),]
  tvec.nobs <- fn.sim$time[seq(1,nrow(fn.sim), length=config$nobs)]
  
  
  
  foo <- outer(tvec.full, t(tvec.full),'-')[,1,]
  r <- abs(foo)
  r2 <- r^2
  signr <- -sign(foo)
  
  foo <- outer(tvec.nobs, t(tvec.nobs),'-')[,1,]
  r.nobs <- abs(foo)
  r2.nobs <- r.nobs^2
  signr.nobs <- -sign(foo)
  
  marlikmap <- list(par=c(2.314334, 1.346233, 0.622316, 2.451729, 0.084745))
  
  cursigma <- marlikmap$par[5]
  
  curCovV <- magi:::calCov(marlikmap$par[1:2], r, signr, bandsize=config$bandsize,
                    kerneltype=config$kernel)
  curCovR <- magi:::calCov(marlikmap$par[3:4], r, signr, bandsize=config$bandsize,
                    kerneltype=config$kernel)
  
  curCovV$mu <- as.vector(fn.true[,1])  # pretend these are the means
  curCovR$mu <- as.vector(fn.true[,2])
  
  dotmu <- magi:::fODE(pram.true$abc, fn.true[,1:2]) # pretend these are the means for derivatives
  curCovV$dotmu <- as.vector(dotmu[,1])  
  curCovR$dotmu <- as.vector(dotmu[,2])
  
  
  nall <- nrow(fn.sim)
  numparam <- nall*2+3
  n.iter <- config$n.iter
  stepLow.traj <- xth.formal <- matrix(NA, n.iter, numparam)
  xth.formal[1,] <- c(fn.true$Vtrue, fn.true$Rtrue, pram.true$abc)
  lliklist <- accepts <- c()
  accepts[1] <- 1
  
  burnin <- as.integer(n.iter*config$burninRatio)
  stepLow <- rep(0.001, 2*nall+3)*config$stepSizeFactor
  
  t <- 2
  
  rstep <- stepLow
  foo <- magi:::xthetaSample(data.matrix(fn.sim[,1:2]), list(curCovV, curCovR), cursigma,
                      xth.formal[t-1,], rstep, config$hmcSteps, F, loglikflag = config$loglikflag)
  out <- magi:::parallel_temper_hmc_xtheta(
    data.matrix(fn.sim[,1:2]),
    curCovV,
    curCovR,
    cursigma,
    c(1, 1.5, 2:7),
    0.5,
    xth.formal[t-1,],
    rstep,
    config$hmcSteps,
    config$n.iter)
  
  
  xInit <- c(fn.true$Vtrue, fn.true$Rtrue, pram.true$abc)
  stepLowInit <- rep(0.001, 2*nall+3)*config$stepSizeFactor
  
  singleSampler <- function(xthetaValues, stepSize)
    magi:::xthetaSample(data.matrix(fn.sim[,1:2]), list(curCovV, curCovR), cursigma,
                 xthetaValues, stepSize, config$hmcSteps, F, loglikflag = config$loglikflag, 
                 overallTemperature = 7)
  
  chainSamplesOut <- magi:::chainSampler(config, xInit, singleSampler, stepLowInit, verbose=TRUE)
  plot(out[405,8,], type="l")
  lines(chainSamplesOut[[1]][,404], col=2)
  hist(out[405,8,], col=rgb(1,0,0,0.5), probability=T)
  hist(chainSamplesOut[[1]][,404], col=rgb(0,1,0,0.5), add=T, probability=T)
  x <- suppressWarnings(ks.test(out[405,8,], chainSamplesOut[[1]][,404]))
  # testthat::expect_gt(x$p.value, 0.01)
  
  x <- magi:::xthetallikBandApproxC(data.matrix(fn.sim[,1:2]), curCovV, curCovR, cursigma,
                             chainSamplesOut[[1]][2,])
  
  testthat::expect_equal(chainSamplesOut$lliklist[2], x$value/7)
})

