% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getYears.R, R/setYears.R
\name{getYears}
\alias{getYears}
\alias{getYears<-}
\alias{setYears}
\alias{getYears<-}
\alias{setYears}
\title{Get years}
\usage{
getYears(x, as.integer = FALSE)

getYears(x) <- value

setYears(object, nm = NULL)
}
\arguments{
\item{x, object}{MAgPIE object}

\item{as.integer}{Switch to decide, if output should be the used year-name
(e.g. "y1995") or the year as integer value (e.g. 1995)}

\item{value, nm}{Years the data should be set to. Either supplied as a vector
of integers or a vector of characters in the predefined year format
("y0000"). If only 1 year exist you can also set the name of the year to
NULL.}
}
\value{
getYears returns years of the MAgPIE-object, whereas setYears
returns the MAgPIE object with the manipulated years.
}
\description{
Extracts years of a MAgPIE-object
}
\details{
setYears is a shortcut to use a MAgPIE object with manipulated year names.
setYears uses the variable names "object" and "nm" in order to be consistent
to the already existing function setNames.
}
\section{Functions}{
\itemize{
\item \code{getYears<-}: rename years

\item \code{setYears}: set years
}}

\examples{

 a <- as.magpie(1)
 getYears(a)
 setYears(a,1995)

}
\seealso{
\code{\link{getRegions}}, \code{\link{getNames}},
\code{\link{setNames}}, \code{\link{getCPR}}, \code{\link{read.magpie}},
\code{\link{write.magpie}}, \code{"\linkS4class{magpie}"}
}
\author{
Jan Philipp Dietrich
}
