% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-data_evaluate.R
\name{data_dict_evaluate}
\alias{data_dict_evaluate}
\title{Generate an assessment report for a data dictionary}
\usage{
data_dict_evaluate(data_dict, taxonomy = NULL, as_data_dict_mlstr = TRUE)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be evaluated.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}

\item{as_data_dict_mlstr}{Whether the input data dictionary should be coerced
with specific format restrictions for compatibility with other
Maelstrom Research software. TRUE by default.}
}
\value{
A list of data frames containing assessment reports.
}
\description{
Assesses the content and structure of a data dictionary and generates reports
of the results. The report can be used to help assess data dictionary
structure, presence of fields, coherence across elements, and taxonomy
or data dictionary formats.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}. The function truncates each cell to a maximum of
10000 characters, to be readable and compatible with Excel.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.

The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

data_dict <- madshapR_DEMO$`data_dict_TOKYO - errors`
glimpse(data_dict_evaluate(data_dict))

}

}
