% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-data_summarise.R
\name{summary_variables_text}
\alias{summary_variables_text}
\title{Provide descriptive statistics for variables of type 'text' in a dataset}
\usage{
summary_variables_text(
  dataset = NULL,
  data_dict = NULL,
  .dataset_preprocess = NULL
)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}

\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset. Automatically generated if not provided.}

\item{.dataset_preprocess}{A tibble which provides summary of the variables
(for internal processes and programming).}
}
\value{
A tibble providing statistical description of 'text' variables present
in a dataset.
}
\description{
Summarises (in a tibble) the columns of type 'text' in a dataset and its
data dictionary (if any). The summary provides information about quality,
type, composition, and descriptive statistics of variables. Statistics are
generated by valueType.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.
}
\examples{
{
   
###### Example : any data frame (or tibble) can be a dataset by definition.
library(dplyr)

.dataset_preprocess <- dataset_preprocess(starwars['homeworld'])
summary_variables_text(.dataset_preprocess = .dataset_preprocess)

}

}
