% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multidim_layers.R
\name{background.plot}
\alias{background.plot}
\title{Plot background of multidimensional plots}
\usage{
background.plot(range_faxes, faxes_nm, color_bg)
}
\arguments{
\item{range_faxes}{a vector with minimum and maximum values of axes. Note
that to have a fair representation of position of species in all plots,
they should have the same range. Default: \code{range_faxes = c(NA, NA)} (the
range is computed according to the range of values among all axes).}

\item{faxes_nm}{a vector with axes labels for figure.}

\item{color_bg}{a R color name  or an hexadecimal code used to fill plot
background. Default: \code{color_bg = "grey95"}.}
}
\value{
A ggplot object plotting background of multidimensional graphs.
}
\description{
This function creates a ggplot object with customized axes range
(same for both), names and background
}
\examples{
 background <- background.plot(range_faxes = c(-1, 2), 
                               faxes_nm    = c("PC 1", "PC 2"), 
                               color_bg    = "grey90")
 background 
}
\author{
Camille Magneville and Sebastien Villeger
}
