% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts_used_for_ind_comp.R
\name{dist.nearneighb}
\alias{dist.nearneighb}
\title{Compute distance of a given point to its nearest neighbor in the functional
space and the identity of the nearest neighbor}
\usage{
dist.nearneighb(sp_faxes_coord, ref_sp)
}
\arguments{
\item{sp_faxes_coord}{a matrix of species coordinates in a chosen
functional space. Species coordinates have been retrieved thanks to
\code{\link{tr.cont.fspace}} or \code{\link{quality.fspaces}}.}

\item{ref_sp}{a character string referring to the name of the reference
species.}
}
\value{
A list containing the nearest neighbor identity \code{nn_id} and a
list of the distance of the reference point to its nearest neighbor
\code{nn_ref_sp_dist}.
}
\description{
This function is used in functional indices computation.
}
\examples{
# Load Species*Traits dataframe:
 data("fruits_traits", package = "mFD")

# Load Assemblages*Species dataframe:      
 data("baskets_fruits_weights", package = "mFD") 

# Load Traits categories dataframe:
 data("fruits_traits_cat", package = "mFD") 
 
# Compute functional distance 
 sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                   tr_cat        = fruits_traits_cat,
                                   metric        = "gower",
                                   scale_euclid  = "scale_center",
                                   ordinal_var   = "classic",
                                   weight_type   = "equal",
                                   stop_if_NA    = TRUE)
  
# Compute functional spaces quality to retrieve species coordinates matrix:
 fspaces_quality_fruits <- mFD::quality.fspaces(
                                  sp_dist             = sp_dist_fruits, 
                                  maxdim_pcoa         = 10,
                                  deviation_weighting = "absolute",
                                  fdist_scaling       = FALSE,
                                  fdendro             = "average")
 
# Retrieve species coordinates matrix:
 sp_faxes_coord_fruits <- fspaces_quality_fruits$details_fspaces$sp_pc_coord

# Compute the distance of "pear" to its nearest neighbor(s):
 dist_nn_pear <- dist.nearneighb(sp_faxes_coord_fruits, ref_sp = "pear")
 dist_nn_pear
}
\author{
Camille Magneville and Sebastien Villeger
}
