% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funct_dist_computation.R
\name{funct.dist}
\alias{funct.dist}
\title{Compute functional distance between species}
\usage{
funct.dist(
  sp_tr,
  tr_cat,
  metric,
  scale_euclid = "scale_center",
  ordinal_var = "classic",
  weight_type = "equal",
  stop_if_NA = TRUE
)
}
\arguments{
\item{sp_tr}{a data frame of traits values (columns) for each species
(rows).}

\item{tr_cat}{a data frame containing three columns for each trait (rows):
\itemize{
\item \strong{trait_name}: the name of all traits as in \code{sp_tr} data
frame;
\item \strong{trait_type}: the category code for each trait as followed:
\code{N} for Nominal traits (factor variable), \code{O} for Ordinal traits
(ordered variable), \code{C} for Circular traits (integer values),
\code{Q} for quantitative traits (numeric values) that is allowed
\strong{only} if there are at least 2 species with the same value, and
\code{F} for fuzzy traits (i.e. described with several values defined with
several column); \item \strong{fuzzy_name}: name of fuzzy-coded trait to
which 'sub-trait' belongs (if trait is not fuzzy, ignored so could be
trait name or NA). \item \strong{trait_weight}: Optional, a numeric vector
of length n (traits number) to specify a weight for each trait.
}}

\item{metric}{the distance to be computed:
\code{euclidean}, the Euclidean distance,
\code{gower}, the Classical Gower distance as defined by Gower (1971), extent
by de Bello \emph{et al.} (2021) and based on the \code{\link[gawdis]{gawdis}}
function.}

\item{scale_euclid}{only when computing euclidean distance a string value to
compute (or not) scaling of quantitative traits using the
\code{\link{tr.cont.scale}} function.
Possible options are:
\code{range} (standardize by the range:
\eqn{({x' = x - min(x) )} / (max(x) - min (x))})
\code{center} (use the center transformation: \eqn{x' = x - mean(x)}),
\code{scale} (use the scale transformation: \eqn{x' = \frac{x}{sd(x)}}),
\code{scale_center} (use the scale-center transformation:
\eqn{x' = \frac{x - mean(x)}{sd(x)}}), or
\code{noscale} traits are not scaled
Default is \code{scale_center}.}

\item{ordinal_var}{a character string specifying the method to be used for
ordinal variables (i.e. ordered).
\code{classic} simply treats ordinal variables as continuous variables;
\code{metric} refers to Eq. 3 of Podani (1999);
\code{podani} refers to Eqs. 2a-b of Podani (1999),
Both options convert ordinal variables to ranks. Default is \code{classic}.}

\item{weight_type}{the type of used method to weight traits.
\code{user} user defined weights in tr_cat,
\code{equal} all traits having the same weight.
More methods are available using \code{\link[gawdis]{gawdis}} from
\code{gawdis} package. To compute gower distance with fuzzy trait and
weight please refer to \code{\link[gawdis]{gawdis}}. Default is \code{equal}.}

\item{stop_if_NA}{a logical value to stop or not the process if the
\code{sp_tr} data frame contains NA. Functional measures are sensitive to
missing traits. For further explanations, see the Note section.
Default is \code{TRUE}.}
}
\value{
a \code{dist} object containing distance between each pair of species.
}
\description{
For a given combination of traits, this function returns the functional
distance matrix between species.
}
\note{
If the \code{sp_tr} data frame contains \code{NA} you can either
chose to compute anyway functional distances (but keep in mind that
\strong{Functional measures are sensitive to missing traits!}) or you can
delete species with missing or extrapolate missing traits (see
Johnson \emph{et al.} (2020)).
}
\examples{
# Load Species x Traits data
data("fruits_traits", package = "mFD")

# Load Traits x Categories data
data("fruits_traits_cat", package = "mFD")

# Remove fuzzy traits for this example and thus remove lat column:
fruits_traits     <- fruits_traits[ , -c(6:8)]
fruits_traits_cat <- fruits_traits_cat[-c(6:8), ]
fruits_traits_cat <- fruits_traits_cat[ , -3]

# Compute Functional Distance
sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                  tr_cat        = fruits_traits_cat,
                                  metric        = "gower",
                                  scale_euclid  = "scale_center",
                                  ordinal_var   = "classic",
                                  weight_type   = "equal",
                                  stop_if_NA    = TRUE)
sp_dist_fruits
}
\references{
de Bello \emph{et al.} (2021) Towards a more balanced combination of multiple
traits when computing functional differences between species.
\emph{Method in Ecology and Evolution}, \strong{12}, 443-448.\cr
Gower (1971 ) A general coefficient of similarity and some of its
properties. \emph{Biometrics}, \strong{27}, 857-871.\cr
Johnson \emph{et al.} (2020) Handling missing values in trait data.
\emph{Global Ecology and Biogeography}, \strong{30}, 51-62.\cr
Podani (1999) Extending Gower's general coefficient of similarity to ordinal
characters, \emph{Taxon}, \strong{48}, 331-340.
}
\author{
Nicolas Loiseau and Sebastien Villeger
}
