% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxExtrapDemand.R
\name{roundSum}
\alias{roundSum}
\title{Round elements in matrix or data.frame rows}
\usage{
roundSum(x, ncell, ...)
}
\arguments{
\item{x}{matrix or data.frame}

\item{ncell}{numeric specifying the target sum for each row in \code{x}}

\item{\dots}{additional arguments (none)}
}
\value{
A matrix.
}
\description{
Round all numbers in a matrix or data.frame while ensuring that all rows sum
to the same value.
}
\details{
The main application of \code{roundSum} is to ensure that each row in the
demand matrix specifies exactly the number of cells to be allocated to each
land use category for the respective timestep. It may also be used to convert
the units of demand to number of cells.
}
\examples{

## Sibuyan Island

## load observed land use data and create demand scenario
obs <- ObsLulcRasterStack(x=sibuyan$maps,
                    pattern="lu",
                    categories=c(1,2,3,4,5),
                    labels=c("Forest","Coconut","Grass","Rice","Other"),
                    t=c(0,14))

dmd <- approxExtrapDemand(obs, tout=0:14)
apply(dmd, 1, sum)

## artificially perturb for illustration purposes
dmd <- dmd * runif(1)
apply(dmd, 1, sum)

## use roundSum to correct demand scenario
ncell <- length(which(!is.na(getValues(sibuyan$maps$lu_sib_1997))))
ncell
dmd <- roundSum(dmd, ncell=ncell)
apply(dmd, 1, sum)

}
