% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recordLink.R
\name{recordLink}
\alias{recordLink}
\title{Probabilistic Patient Record Linkage}
\usage{
recordLink(data1, data2, dates1 = NULL, dates2 = NULL, eps_plus,
  eps_minus, aggreg_2ways = "mean", min_prev = 0.01,
  data1_cont2diff = NULL, data2_cont2diff = NULL, d_max,
  use_diff = TRUE)
}
\arguments{
\item{data1}{either a binary (\code{1} or \code{0} values only) matrix or binary 
data frame of dimension \code{n1 x K} whose rownames are the observation identifiers.}

\item{data2}{either a binary (\code{1} or \code{0} values only) matrix or a binary
data frame of dimension \code{n2 x K} whose rownames are the observation identifiers.}

\item{dates1}{matrix or dataframe of dimension \code{n1 x K} including the concatenated dates intervals for each corresponding 
diagnosis codes in \code{data1}. Default is \code{NULL} in which case dates are not used.}

\item{dates2}{matrix or dataframe of dimension \code{n2 x K} including the concatenated dates intervals for each corresponding 
diagnosis codes in \code{data2}. Default is \code{NULL} in which case dates are not used. See details.}

\item{eps_plus}{discrepancy rate between \code{data1} and \code{data2}}

\item{eps_minus}{discrepancy rate between \code{data2} and \code{data1}}

\item{aggreg_2ways}{a character string indicating how to merge the posterior two 
probability matrices obtained for each of the 2 databases. Four possibility are 
currently implemented: \code{"maxnorm"}, \code{"max"}, \code{"min"}, \code{"mean"} 
and \code{"prod"}. Default is \code{"mean"}.}

\item{min_prev}{minimum prevalence for the variables used in matching.
Default is 1\%.}

\item{data1_cont2diff}{either a matrix or dataframe of continuous features, 
such as age, for which the similarity measure uses the difference with 
\code{data2_cont2diff}, whose rownames are . Default is \code{NULL}.}

\item{data2_cont2diff}{either a matrix or dataframe of continuous features, 
such as age, for which the similarity measure uses the difference with 
\code{data2_cont1diff}, whose rownames are . Default is \code{NULL}.}

\item{d_max}{a numeric vector of length \code{K} giving the minimum difference 
from which it is considered a discrepancy.}

\item{use_diff}{logical flag indicating whether continuous differentiable variables should be used in the}
}
\value{
a matrix of size \code{n1 x n2} with the posterior probability of matching for each \code{n1*n2} pair
}
\description{
Probabilistic Patient Record Linkage
}
\details{
\code{Dates:} the use of \code{dates1} and \code{dates2} requires that at least one date interval matches across 
\code{dates1} and \code{dates2} for claiming an agreement on a diagnosis code between \code{data1} and \code{data2}, 
in addition of having that very same code recorded in both.
}
\examples{
set.seed(123)
ncodes <- 500
npat <- 200
incid <- abs(rnorm(n=ncodes, 0.15, 0.07))
bin_codes <- rbinom(n=npat*ncodes, size=1,  prob=rep(incid, npat))
bin_codes_mat <- matrix(bin_codes, ncol=ncodes, byrow = TRUE)
data1_ex <- bin_codes_mat[1:(npat/2+npat/10),]
data2_ex <- bin_codes_mat[c(1:(npat/10), (npat/2+npat/10 + 1):npat), ]
rownames(data1_ex) <- paste0("ID", 1:(npat/2+npat/10), "_data1")
rownames(data2_ex) <- paste0("ID", c(1:(npat/10), (npat/2+npat/10 + 1):npat), "_data2")

if(interactive()){
res <- recordLink(data1 = data1_ex, data2 = data2_ex, 
                 use_diff = FALSE, eps_minus = 0.01, eps_plus = 0.01)
round(res[c(1:3, 19:23), c(1:3, 19:23)], 3)
}

}
\references{
Hejblum BP, Weber G, Liao KP, Palmer N, Churchill S, Szolovits P, Murphy S, Kohane I, Cai T 
Probabilistic Record Linkage of De-Identified Research Datasets Using Diagnosis Codes, \emph{submitted}, 2017.
}
