% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_winkler.R
\name{em_winkler}
\alias{em_winkler}
\alias{em_winkler_big}
\title{Implementation of Winkler's EM algorithmf or Fellegi-Sunter matching method}
\usage{
em_winkler(data1, data2, tol = 0.001, maxit = 500, do_plot = TRUE,
  verbose = FALSE)

em_winkler_big(data1, data2, tol = 0.001, maxit = 500, do_plot = TRUE,
  verbose = FALSE)
}
\arguments{
\item{data1}{either a binary matrix or dataframe whose rownames are .}

\item{data2}{either a binary matrix or a dataframe whose rownames are .}

\item{tol}{tolerance for the EM algorithm convergence}

\item{maxit}{maximum number of iterations for the EM algorithm}

\item{do_plot}{a logical flag indicating whether a plot should be drawn for the EM convergence. 
Default is \code{TRUE}}

\item{verbose}{a logical flag indicating wehther intermediate values from the EM algorithm should 
be printed. Useful for debugging. Default is \code{FALSE}.}
}
\value{
a matrix of size \code{n1 x n2} with the matching score for each \code{n1*n2} pair.
}
\description{
Implementation of Winkler's EM algorithmf or Fellegi-Sunter matching method

\code{em_winkler_big} implements the same method when the data are too big to compute 
the agreement matrix. Agreement is then recomputed on the fly each time it is needed. The EM steps 
are completely done in C++. This decreases the RAM usage (still important though), at the cost of 
increasing computationnal time.
}
\examples{
mat1 <- matrix(round(rnorm(n=1000, sd=1.2)), ncol=10, nrow=100)
mat2 <- rbind(mat1[1:10, ],
             matrix(round(rnorm(n=900, sd=1.2)), ncol=10, nrow=90)
             )
rownames(mat1) <- paste0("A", 1:nrow(mat1))
rownames(mat1) <- paste0("B", 1:nrow(mat1))
mat1 <- 1*(mat1>1)
mat2 <- 1*(mat2>1)
em_winkler(mat1, mat2)

}
\references{
Winkler WE. Using the EM Algorithm for Weight Computation in the Fellegi-Sunter Model of Record Linkage. Proc Sect Surv Res Methods, Am Stat Assoc 1988: 667-71.

Grannis SJ, Overhage JM, Hui S, et al. Analysis of a probabilistic record linkage technique without human review. AMIA 2003 Symp Proc 2003: 259-63.
}

