% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.r
\docType{package}
\name{lubridate-package}
\alias{lubridate}
\alias{lubridate-package}
\title{Dates and times made easy with lubridate}
\description{
Lubridate provides tools that make it easier to parse and
manipulate dates. These tools are grouped below by common
purpose. More information about each function can be found in
its help documentation.
}
\section{Parsing dates}{


Lubridate's parsing functions read strings into R as POSIXct
date-time objects. Users should choose the function whose name
models the order in which the year ('y'), month ('m') and day
('d') elements appear the string to be parsed:
\code{\link[=dmy]{dmy()}}, \code{\link[=myd]{myd()}}, \code{\link[=ymd]{ymd()}},
\code{\link[=ydm]{ydm()}}, \code{\link[=dym]{dym()}}, \code{\link[=mdy]{mdy()}},
\code{\link[=ymd_hms]{ymd_hms()}}). A very flexible and user friendly parser
is provided by \code{\link[=parse_date_time]{parse_date_time()}}.

Lubridate can also parse partial dates from strings into
\linkS4class{Period} objects with the functions
\code{\link[=hm]{hm()}}, \code{\link[=hms]{hms()}} and \code{\link[=ms]{ms()}}.

Lubridate has an inbuilt very fast POSIX parser. Most of the \code{\link[=strptime]{strptime()}}
formats and various extensions are supported for English locales. See
\code{\link[=parse_date_time]{parse_date_time()}} for more details.
}

\section{Manipulating dates}{


Lubridate distinguishes between moments in time (known as
\code{\link[=instants]{instants()}}) and spans of time (known as time spans, see
\linkS4class{Timespan}). Time spans are further separated into
\linkS4class{Duration}, \linkS4class{Period} and
\linkS4class{Interval} objects.
}

\section{Instants}{


Instants are specific moments of time. Date, POSIXct, and
POSIXlt are the three object classes Base R recognizes as
instants. \code{\link[=is.Date]{is.Date()}} tests whether an object
inherits from the Date class. \code{\link[=is.POSIXt]{is.POSIXt()}} tests
whether an object inherits from the POSIXlt or POSIXct classes.
\code{\link[=is.instant]{is.instant()}} tests whether an object inherits from
any of the three classes.

\code{\link[=now]{now()}} returns the current system time as a POSIXct
object. \code{\link[=today]{today()}} returns the current system date.
For convenience, 1970-01-01 00:00:00 is saved to
\link{origin}. This is the instant from which POSIXct
times are calculated. Try \code{unclass(now())} to see the numeric structure that
underlies POSIXct objects. Each POSIXct object is saved as the number of seconds
it occurred after 1970-01-01 00:00:00.

Conceptually, instants are a combination of measurements on different units
(i.e, years, months, days, etc.). The individual values for
these units can be extracted from an instant and set with the
accessor functions \code{\link[=second]{second()}}, \code{\link[=minute]{minute()}},
\code{\link[=hour]{hour()}}, \code{\link[=day]{day()}}, \code{\link[=yday]{yday()}},
\code{\link[=mday]{mday()}}, \code{\link[=wday]{wday()}}, \code{\link[=week]{week()}},
\code{\link[=month]{month()}}, \code{\link[=year]{year()}}, \code{\link[=tz]{tz()}},
and \code{\link[=dst]{dst()}}.
Note: the accessor functions are named after the singular form
of an element. They shouldn't be confused with the period
helper functions that have the plural form of the units as a
name (e.g, \code{\link[=seconds]{seconds()}}).
}

\section{Rounding dates}{


Instants can be rounded to a convenient unit using the
functions \code{\link[=ceiling_date]{ceiling_date()}}, \code{\link[=floor_date]{floor_date()}}
and \code{\link[=round_date]{round_date()}}.
}

\section{Time zones}{


Lubridate provides two helper functions for working with time
zones. \code{\link[=with_tz]{with_tz()}} changes the time zone in which an
instant is displayed. The clock time displayed for the instant
changes, but the moment of time described remains the same.
\code{\link[=force_tz]{force_tz()}} changes only the time zone element of an
instant. The clock time displayed remains the same, but the
resulting instant describes a new moment of time.
}

\section{Timespans}{


A timespan is a length of time that may or may not be connected to
a particular instant. For example, three months is a timespan. So is an hour and
a half. Base R uses difftime class objects to record timespans.
However, people are not always consistent in how they expect time to behave.
Sometimes the passage of time is a monotone progression of instants that should
be as mathematically reliable as the number line. On other occasions time must
follow complex conventions and rules so that the clock times we see reflect what
we expect to observe in terms of daylight, season, and congruence with the
atomic clock. To better navigate the nuances of time, \pkg{lubridate} creates three
additional timespan classes, each with its own specific and consistent behavior:
\linkS4class{Interval}, \linkS4class{Period} and
\linkS4class{Duration}.

\code{\link[=is.difftime]{is.difftime()}} tests whether an object
inherits from the difftime class. \code{\link[=is.timespan]{is.timespan()}}
tests whether an object inherits from any of the four timespan
classes.
}

\section{Durations}{


Durations measure the exact amount of time that occurs between two
instants. This can create unexpected results in relation to clock times if a
leap second, leap year, or change in daylight savings time (DST) occurs in
the interval.

Functions for working with durations include \code{\link[=is.duration]{is.duration()}},
\code{\link[=as.duration]{as.duration()}} and \code{\link[=duration]{duration()}}. \code{\link[=dseconds]{dseconds()}},
\code{\link[=dminutes]{dminutes()}}, \code{\link[=dhours]{dhours()}},  \code{\link[=ddays]{ddays()}},
\code{\link[=dweeks]{dweeks()}} and \code{\link[=dyears]{dyears()}} convenient lengths.
}

\section{Periods}{


Periods measure the change in clock time that occurs between two
instants. Periods provide robust predictions of clock time in the presence of
leap seconds, leap years, and changes in DST.

Functions for working with periods include
\code{\link[=is.period]{is.period()}}, \code{\link[=as.period]{as.period()}} and
\code{\link[=period]{period()}}. \code{\link[=seconds]{seconds()}},
\code{\link[=minutes]{minutes()}}, \code{\link[=hours]{hours()}}, \code{\link[=days]{days()}},
\code{\link[=weeks]{weeks()}}, \code{\link[=months]{months()}} and
\code{\link[=years]{years()}} quickly create periods of convenient
lengths.
}

\section{Intervals}{


Intervals are timespans that begin at a specific instant and
end at a specific instant. Intervals retain complete information about a
timespan. They provide the only reliable way to convert between
periods and durations.

Functions for working with intervals include
\code{\link[=is.interval]{is.interval()}}, \code{\link[=as.interval]{as.interval()}},
\code{\link[=interval]{interval()}}, \code{\link[=int_shift]{int_shift()}},
\code{\link[=int_flip]{int_flip()}}, \code{\link[=int_aligns]{int_aligns()}},
\code{\link[=int_overlaps]{int_overlaps()}}, and
\code{\link{\%within\%}}. Intervals can also be manipulated with
intersect, union, and setdiff().
}

\section{Miscellaneous}{


\code{\link[=decimal_date]{decimal_date()}} converts an instant to a decimal of
its year.
\code{\link[=leap_year]{leap_year()}} tests whether an instant occurs during
a leap year.
\code{\link[=pretty_dates]{pretty_dates()}} provides a method of making pretty
breaks for date-times.
\link{lakers} is a data set that contains information
about the Los Angeles Lakers 2008-2009 basketball season.
}

\references{
Garrett Grolemund, Hadley Wickham (2011). Dates and Times Made
Easy with lubridate. Journal of Statistical Software, 40(3), 1-25.
\url{https://www.jstatsoft.org/v40/i03/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://lubridate.tidyverse.org}
  \item \url{https://github.com/tidyverse/lubridate}
  \item Report bugs at \url{https://github.com/tidyverse/lubridate/issues}
}

}
\author{
\strong{Maintainer}: Vitalie Spinu \email{spinuvit@gmail.com}

Authors:
\itemize{
  \item Garrett Grolemund
  \item Hadley Wickham
}

Other contributors:
\itemize{
  \item Ian Lyttle [contributor]
  \item Imanuel Costigan [contributor]
  \item Jason Law [contributor]
  \item Doug Mitarotonda [contributor]
  \item Joseph Larmarange [contributor]
  \item Jonathan Boiser [contributor]
  \item Chel Hee Lee [contributor]
  \item Google Inc. [contributor, copyright holder]
}

}
\keyword{internal}
