% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lua_open.R
\name{lua_reset}
\alias{lua_reset}
\title{Reset the default Lua state}
\usage{
lua_reset()
}
\value{
None.
}
\description{
Clears out all variables from the default Lua state, freeing up the
associated memory.
}
\details{
This resets the default \link[=lua_open]{Lua state} only. To reset a non-default
Lua state \code{L} returned by \code{\link[=lua_open]{lua_open()}}, just do \code{L <- lua_open()} again. The
memory previously used will be cleaned up at the next garbage collection.
}
\examples{
lua("a = 2")
lua_reset()
lua("print(a)") # nil
}
