% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_gen_separate.R
\name{cluster_gen_separate}
\alias{cluster_gen_separate}
\title{Generate cluster samples with individual questionnaires}
\usage{
cluster_gen_separate(
  n_levels,
  n,
  N,
  sum_pop,
  calc_weights,
  sampling_method,
  cluster_labels,
  resp_labels,
  collapse,
  n_X,
  n_W,
  cat_prop,
  c_mean,
  sigma,
  cor_matrix,
  rho,
  theta,
  whitelist,
  verbose,
  ...
)
}
\arguments{
\item{n_levels}{number of cluster levels}

\item{n}{numeric vector with the number of sampled observations (clusters or subjects) on each level}

\item{N}{list of numeric vector with the population size of each *sampled* cluster element on each level}

\item{sum_pop}{total population at the lowest level (sampled or not)}

\item{calc_weights}{if `TRUE`, sampling weights are calculated}

\item{sampling_method}{can be "SRS" for Simple Random Sampling or "PPS" for Probabilities Proportional to Size, "mixed" to use SRS for students and PPS otherwise or a vector with the sampling method for each level}

\item{cluster_labels}{character vector with the names of each cluster level}

\item{resp_labels}{character vector with the names of the questionnaire respondents on each level}

\item{collapse}{if `TRUE`, function output contains only one data frame with all answers}

\item{n_X}{list of `n_X` per cluster level}

\item{n_W}{list of `n_W` per cluster level}

\item{cat_prop}{list of cumulative proportions for each item. If \code{theta
= TRUE}, the first element of \code{cat_prop} must be a scalar 1, which
corresponds to the \code{theta}.}

\item{c_mean}{vector of means for the continuous variables or list of vectors for the continuous variables for each level}

\item{sigma}{vector of standard deviations for the continuous variables or list of vectors for the continuous variables for each level}

\item{cor_matrix}{Correlation matrix between all variables (except weights)}

\item{rho}{estimated intraclass correlation}

\item{theta}{if \code{TRUE}, the first continuous variable will be labeled
'theta'. Otherwise, it will be labeled 'q1'.}

\item{whitelist}{used when `n = select(...)`, determines which PSUs get to generate questionnaires}

\item{verbose}{if `TRUE`, prints output messages}

\item{...}{Additional parameters to be passed to `questionnaire_gen()`}
}
\description{
This is a subfunction of `cluster_gen` that performs cluster sampling, with the twist that each cluster level has its own questionnaire.
}
\seealso{
cluster_gen cluster_gen_together
}
