% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{mTPI2Table}
\alias{mTPI2Table}
\title{mTPI-2 decision table}
\usage{
mTPI2Table(
  nMax = NA_integer_,
  pT = 0.3,
  epsilon1 = 0.05,
  epsilon2 = 0.05,
  a = 1,
  b = 1,
  pExcessTox = 0.95
)
}
\arguments{
\item{nMax}{The maximum number of subjects in a dose cohort.}

\item{pT}{The target toxicity probability. Defaults to 0.3.}

\item{epsilon1}{The lower equivalence margin from the target.
Defaults to 0.05.}

\item{epsilon2}{The upper equivalence margin from the target.
Defaults to 0.05.}

\item{a}{The prior toxicity parameter for the beta prior.}

\item{b}{The prior non-toxicity parameter for the beta prior.}

\item{pExcessTox}{The threshold for excessive toxicity, i.e.,
if Prob(p > pT | Data) > pExcessTox, then the current and
all higher doses will be excluded and never be used again
in the remainder of the trial to avoid any other subjects
receiving treatment at those doses. Defaults to 0.95.}
}
\value{
An S3 class \code{mTPI2Table} object with the following
components:
\itemize{
\item \code{settings}: The input settings data frame with the following
variables:
\itemize{
\item \code{nMax}: The maximum number of subjects in a dose cohort.
\item \code{pT}: The target toxicity probability.
\item \code{epsilon1}: The lower equivalence margin from the target.
\item \code{epsilon2}: The upper equivalence margin from the target.
\item \code{a}: The prior toxicity parameter for the beta prior.
\item \code{b}: The prior non-toxicity parameter for the beta prior.
\item \code{pExcessTox}: The threshold for excessive toxicity.
}
\item \code{subintervals}: The subintervals of equal length in the mTPI-2
design. It includes the following variables:
\itemize{
\item \code{lower}: The lower bound of the subinterval.
\item \code{upper}: The upper bound of the subinterval.
\item \code{decision}: The dosing decision for the subinterval.
}
\item \code{decisionDataFrame}: The decision data frame for the mTPI-2 design.
It includes the following variables:
\itemize{
\item \code{n}: The sample size.
\item \code{y}: The number of toxicities.
\item \code{decision}: The dosing decision.
}
\item \code{decisionMatrix}: The decision matrix corresponding to the
decision data frame.
}
}
\description{
Obtains the decision table for the modified toxicity
probability interval-2 (mTPI-2) design.
}
\examples{

mTPI2Table(nMax = 18, pT = 0.3, epsilon1 = 0.05, epsilon2 = 0.05)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
