% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kmest}
\alias{kmest}
\title{Kaplan-Meier estimates of the survival curve}
\usage{
kmest(
  data,
  rep = "rep",
  stratum = "stratum",
  time = "time",
  event = "event",
  conftype = "log-log",
  confint = 0.95
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{time}: The possibly right-censored survival time.
\item \code{event}: The event indicator.
}}

\item{rep}{The name of the replication variable in the input data.}

\item{stratum}{The name of the stratum variable in the input data.}

\item{time}{The name of the time variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{conftype}{The type of confidence interval. One of "none",
"plain", "log", "log-log" (the default), or "arcsin".
The arcsin option bases the intervals on asin(sqrt(survival)).}

\item{confint}{The level of the two-sided confidence interval for
the survival probabilities. Defaults to 0.95.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{rep}: The replication.
\item \code{stratum}: The stratum.
\item \code{size}: The number of subjects in the stratum.
\item \code{time}: The event time.
\item \code{nrisk}: The number of subjects at risk.
\item \code{nevent}: The number of subjects having the event.
\item \code{survival}: The Kaplan-Meier estimate of the survival probability.
\item \code{stderr}: The standard error of the estimated survival
probability based on the Greendwood formula.
\item \code{lower}: The lower bound of confidence interval if requested.
\item \code{upper}: The upper bound of confidence interval if requested.
\item \code{confint}: The level of confidence interval if requested.
\item \code{conftype}: The type of confidence interval if requested.
}
}
\description{
Obtains the Kaplan-Meier estimates of the survival curve.
}
\examples{

kmest(data = survival::aml, stratum = "x",
      time = "time", event = "status")

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
