% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ad}
\alias{ad}
\title{Number of Patients Enrolled During an Interval and Having an Event
by Specified Calendar Times}
\usage{
ad(
  time = NA_real_,
  u1 = NA_real_,
  u2 = NA_real_,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda = NA_real_,
  gamma = 0L
)
}
\arguments{
\item{time}{A vector of calendar times at which to calculate the number
of patients having an event.}

\item{u1}{Lower bound of the accrual time interval.}

\item{u2}{Upper bound of the accrual time interval.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event. One for
each analysis time interval.}

\item{gamma}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout.}
}
\value{
A vector of number of patients who are enrolled during a
specified enrollment time interval and have an event by the specified
calendar times for a given treatment group had the enrollment being
restricted to the treatment group. By definition, we must have
\code{time >= u2}.
}
\description{
Obtains the number of patients who are enrolled during a
specified enrollment time interval and have an event by the specified
calendar times.
}
\examples{
# Piecewise accrual, 10 patients per month for the first 3 months, and
# 20 patients per month thereafter. Piecewise exponential survival with
# hazard 0.0533 in the first 6 months, and hazard 0.0309 thereafter,
# and 5\% dropout by the end of 1 year.

ad(time = c(9, 15), u1 = 1, u2 = 8, accrualTime = c(0, 3),
   accrualIntensity = c(10, 20), piecewiseSurvivalTime=c(0, 6),
   lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
