% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLData_subset.R
\name{subset.LPJmLData}
\alias{subset.LPJmLData}
\title{Subset an LPJmLData object}
\usage{
\method{subset}{LPJmLData}(x, ...)
}
\arguments{
\item{x}{An \link{LPJmLData} object}

\item{...}{One or several key-value combinations where keys represent the
dimension names and values represent the requested elements along these
dimensions. Subsets may either specify integer indices, e.g.
\code{cell = c(27411:27416)}, \code{band = -c(14:16, 19:32)}, or character vectors if
the dimension has a dimnames attribute, e.g.
\code{band = c("rainfed rice", "rainfed maize")}.\
Coordinate pairs of individual cells can be selected by providing a tibble
in the form of \code{coords = tibble(lon = ..., lat =...)}. Coordinate values
in the tibble need to be supplied as character vectors. The argument can
also be called \code{coordinates}. When coordinates are supplied as character
vectors to subset either along the \code{lon} or \code{lat} dimension or to subset
by coordinate pair, the function matches the grid cells closest to the
supplied coordinate value.}
}
\value{
An \code{\link{LPJmLData}} object with dimensions resulting from the selection
in \code{subset}. Meta data are updated as well.
}
\description{
Function to extract a subset of the full data in an \code{\link{LPJmLData}} object by
applying selections along one or several of its dimensions.
}
\examples{
\dontrun{

vegc <- read_io(filename = "./vegc.bin.json")

# Subset cells by index
subset(vegc, cell = seq(27410, 27415))
# [...]
# $data |>
#   dimnames() |>
#     .$cell  "27409" "27410" "27411" "27412" "27413" "27414"
#     .$time  "1901-12-31" "1902-12-31" "1903-12-31" "1904-12-31" ...
#     .$band  "1"
# [...]

# Subset time by character vector
subset(vegc, time = c("2001-12-31", "2002-12-31", "2003-12-31"))
# [...]
# $data |>
#   dimnames() |>
#     .$cell  "0" "1" "2" "3" ... "67419"
#     .$time  "2001-12-31" "2002-12-31" "2003-12-31"
#     .$band  "1"
# [...]
}

}
