% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{lori}
\alias{lori}
\title{LORI method.}
\usage{
lori(Y, cov = NULL, lambda1 = NULL, lambda2 = NULL, thresh = 1e-05,
  maxit = 1000, lambda1.max = NULL, lambda2.max = NULL, size = 100,
  trace.it = F, rank.max = 10, plots = F, r.cov = NULL, c.cov = NULL,
  rc.cov = NULL, spe_time = T)
}
\arguments{
\item{Y}{A matrix of counts (nxp).}

\item{cov}{A matrix of row and column covariates (np*K1) in order row1xcol1,row2xcol2,..,rownxcol1,row1xcol2,row2xcol2,...,...,rownxcolp}

\item{lambda1}{A positive number, the regularization parameter for the interaction matrix.}

\item{lambda2}{A positive number, the regularization parameter for the covariate effects.}

\item{thresh}{A number, convergence tolerance of algorithm, by default \code{1e-6}.}

\item{maxit}{An integer, maximum allowed number of iterations.}

\item{lambda1.max}{A positive number, maximum regularization parameter for the interaction matrix.}

\item{lambda2.max}{A positive number, maximum regularization parameter for the covariate effects.}

\item{size}{An integer,size of warm start grid}

\item{trace.it}{A boolean, whether convergence information should be printed}

\item{rank.max}{An integer, maximum rank of interaction matrix (smaller than min(n-1,p-1))}

\item{plots}{A boolean indicating whether graphical displays should be returned}

\item{r.cov}{a vector of indices indicating the indices of the row covariates}

\item{c.cov}{a vector of indices indicating the indices of the column covariates}

\item{rc.cov}{a vector of indices indicating the indices of the row-column covariates}

\item{spe_time}{a boolean indicating whether columns of Y are temporal (months, years, etc.)}
}
\value{
A list with the following elements
\item{X}{nxp matrix of log of expected counts}
\item{mu}{intercept}
\item{alpha}{coefficients of covariates}
\item{theta}{nxp matrix of row-column interactions}
\item{imputed}{nxp matrix of imputed counts}
\item{means}{nxp matrix of expected counts (exp(X))}
\item{list.X}{list of matrices of log of expected counts (same length as grid of lambda)}
\item{list.mu}{list of offsets (same length as grid of lambda)}
\item{list.alpha}{list of regression parameters (same length as grid of lambda)}
\item{list.theta}{list of interaction matrices (same length as grid of lambda)}
\item{lambda1.grid}{vector of lambda1 values used for warm-start}
\item{lambda2.grid}{vector of lambda2 values used for warm-start}
\item{cov}{npxK matrix of covariates}
}
\description{
LORI method.
}
\examples{
\dontshow{
X <- matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- lori(Y, X, 10, 10, size=2)
}
}
