% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{list_fevd}
\alias{list_fevd}
\title{Fit EVD Parameters to a List of Annual Maxima}
\usage{
list_fevd(
  lst,
  evd_mod_str,
  nsloc = NULL,
  outfile = NULL,
  pc_complete = 0.8,
  minyear = 1800,
  maxyear = 2100,
  mslAtt = "annMean"
)
}
\arguments{
\item{lst}{A \code{list} of \code{data.frame}s, each as returned by \code{annual_max()}, containing at least:
\itemize{
\item \code{annMax}: annual maximum values
\item \code{annMean}: annual mean values
\item \code{datestr}: timestamp strings for the maxima
\item \code{date}: POSIX timestamps for the maxima
\item \code{pc_complete}: completeness fraction per year
\item \code{zero}: the zero level
\item \code{nsloc}: optional covariate matrix used in non-stationary models.
}
If non-stationary fitting is required, each element may also include an \code{nsloc} matrix of covariates.}

\item{evd_mod_str}{A \code{character} string specifying which fitting function from \pkg{evd} to use: \code{"fgumbel"}, \code{"fgumbelx"} or \code{"fgev"}.}

\item{nsloc}{Optional \code{matrix} of covariates for non-stationary location modelling. Must have the same number of rows as years retained after filtering.}

\item{outfile}{Optional \code{character} path to a NetCDF file in which to write the results (not currently implemented).}

\item{pc_complete}{Numeric scalar (0-1). Minimum completeness fraction for a year to be included. Defaults to \code{0.8}.}

\item{minyear}{Numeric. Minimum calendar year to include. Defaults to \code{1800}.}

\item{maxyear}{Numeric. Maximum calendar year to include. Defaults to \code{2100}.}

\item{mslAtt}{\code{character}. Name of the attribute to be removed from annMax in each data.frame (e.g.\ \code{"annMean"} or \code{"zero"}). Defaults to \code{"annMean"}.}
}
\value{
A \code{data.frame} with one row per list element, containing the parameters returned by \code{evd_params()} for each annual-max series.
}
\description{
Fits an extreme value distribution to each element of a list of annual maxima series, optionally using non-stationary covariates, and returns a table of fitted parameters.
}
\examples{
dates = seq.Date(as.Date("1990-01-01"),as.Date("2019-12-31"), "day")
lst = lapply(1:10,function(x) loopevd::annual_max(data.frame(date = dates,
                  sea_level = stats::rnorm(length(dates),mean=x/10,sd = x),
                  zero = rep(0,length(dates)))))
loopevd::list_fevd(lst,"fgumbel",pc_complete=0)
}
