% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_map.R
\name{l_layer.map}
\alias{l_layer.map}
\title{Add a Map of class map as Drawings to Loon plot}
\usage{
\method{l_layer}{map}(
  widget,
  x,
  color = "",
  linecolor = "black",
  linewidth = 1,
  label,
  parent = "root",
  index = 0,
  asSingleLayer = TRUE,
  ...
)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{x}{a map object of class \code{\link[maps]{map}} as defined in the
\code{maps} \R package}

\item{color}{fill color, if empty string \code{""}, then the fill is transparant}

\item{linecolor}{outline color}

\item{linewidth}{linewidth of outline}

\item{label}{label used in the layers inspector}

\item{parent}{parent widget path}

\item{index}{position among its siblings. valid values are 0, 1, 2, ...,
'end'}

\item{asSingleLayer}{if \code{TRUE} then all the polygons get placed in a
n-dimension layer of type polygons. Otherwise, if \code{FALSE}, each
polygon gets its own layer.}

\item{...}{additional arguments are not used for this methiod}
}
\value{
If \code{asSingleLayer=TRUE} then returns layer id of polygons layer,
  otherwise group layer that contains polygon children layers.
}
\description{
The maps library provides some map data in polygon which can be
  added as drawings (currently with polygons) to Loon plots. This function
  adds map objects with class map from the maps library as background
  drawings.
}
\examples{
if(interactive()){

if (requireNamespace("maps", quietly = TRUE)) {
  canada <- maps::map("world",  "Canada",
                      fill=TRUE, plot=FALSE)
  p <- l_plot()
  l_map <- l_layer(p, canada,
                   asSingleLayer=TRUE, color = "cornsilk")
  l_map['color'] <- ifelse(grepl("lake", canada$names, TRUE),
                           "lightblue", "cornsilk")
  l_scaleto_layer(p, l_map)
  l_map['active'] <- FALSE
  l_map['active'] <- TRUE
  l_map['tag']
}

}
}
