% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_serialaxes.R
\name{l_serialaxes}
\alias{l_serialaxes}
\title{Create a Serialaxes Widget}
\usage{
l_serialaxes(data, sequence, scaling = "variable", axesLayout = "radial",
  showAxes = TRUE, parent = NULL, ...)
}
\arguments{
\item{data}{a data frame with numerical data only}

\item{sequence}{vector with variable names that defines the axes sequence}

\item{scaling}{one of 'variable', 'data', 'observation' or 'none' to specify
how the data is scaled. See Details for more information}

\item{axesLayout}{either \code{"serial"} or \code{"parallel"}}

\item{showAxes}{boolean to indicate whether axes should be shown or not}

\item{parent}{parent widget path}

\item{...}{state arguments, see \code{\link{l_info_states}}.}
}
\value{
plot handle object
}
\description{
The seerialaxes widget displays multivariate data either as a
  stacked star glyph plot, or as a parallel coordinate plot.
}
\details{
The \code{scaling} state defines how the data is scaled. The axes
  display 0 at one end and 1 at the other. For the following explanation
  assume that the data is in a nxp dimensional matrix. The scaling options
  are then
\tabular{ll}{
variable \tab per column scaling\cr
observation \tab per row scaling\cr
data \tab whole matrix scaling\cr
none \tab do not scale
}
}
\examples{
s <- l_serialaxes(data=oliveAcids, color=olive$Area, title="olive data")
s['axesLayout'] <- 'parallel'
states <- l_info_states(s)
names(states)
}
