% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-imageGlyph.R
\name{geom_imageGlyph}
\alias{geom_imageGlyph}
\title{Add image glyph on scatter plot}
\usage{
geom_imageGlyph(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  images,
  width = 4,
  height = 3,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{ggplot2::layer}.
These are often aesthetics, used to set an aesthetic to a fixed value,
like \code{colour = "red"} or \code{size = 3}.
They may also be parameters to the paired geom/stat.}

\item{images}{a list of images (a raster object, bitmap image). If not provided, \code{geom_point()} will be called.}

\item{width}{width of image}

\item{height}{height of image}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning.
If `TRUE`, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
a \code{geom} layer
}
\description{
The glyph geom is used to create scatterplots with a variety glyphs such as polygon glyph, serialaxes glyph, image glyph, point range glyph and text glyph.
}
\examples{
# image glyph
\donttest{
if(requireNamespace("png")) {
  img_paths <- list.files(file.path(find.package(package = 'loon'), "images"), full.names = TRUE)
  images <- lapply(img_paths, function(path) png::readPNG(path))
  p <- ggplot(data = data.frame(x = 1:6, y = 1:6),
              mapping = aes(x = x, y = y)) +
         geom_imageGlyph(images = images, alpha = 0.4, width = 2, height = 1.5)
  p
}
}

}
\seealso{
\code{\link{geom_polygonGlyph}}, \code{\link{geom_pointrangeGlyph}},
\code{\link{geom_serialAxesGlyph}}, \code{\link{geom_textGlyph}}
}
