% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{sanitizers}
\alias{sanitizers}
\alias{default_ndjson_sanitizer}
\alias{default_ndjson_unsanitizer}
\title{Sanitization for ndJSON.}
\usage{
default_ndjson_sanitizer(string)

default_ndjson_unsanitizer(string)
}
\arguments{
\item{string}{A character vector}
}
\value{
A character vector
}
\description{
\emph{Sanitizers} and \emph{unsanitizers} are functions, with one parameter, that convert a
character vector (of any length) into another (of the same length).
Associated \emph{sanitizer} and \emph{unsanitizer} should be constructed in such a way that the concatenation
\code{unsanitizer(sanitizer())} corresponds to the identity function.
}
\details{
The default sanatizer and unsanatizer are based on the following mapping:\tabular{ll}{
   Character \tab Replacement \cr
   \verb{\{} \tab \verb{__LEFTBRACE__} \cr
   \verb{\}} \tab \verb{__RIGHTBRACE__} \cr
   \verb{"} \tab \verb{__DBLQUOTE__} \cr
   \verb{,} \tab \verb{__COMMA__} \cr
   \verb{\\r} \tab \verb{__CR__} \cr
   \verb{\\n} \tab \verb{__LF__} \cr
}


This type of function is needed because because some characters in a JSON cannot appear unescaped and
since \code{loggit2} reimplements its own very simple string-based JSON parser.
}
