% Generated by roxygen2 (4.0.2): do not edit by hand
\name{level}
\alias{level}
\alias{level.logger}
\alias{level<-}
\alias{level<-.logger}
\title{Set or get the priority level for a logger object.}
\usage{
level(x)

level(x) <- value

\method{level}{logger}(x)

\method{level}{logger}(x) <- value
}
\arguments{
\item{x}{An object of class logger.}

\item{value}{A loglevel.}
}
\description{
The priority level can be an integer from the set 1..5 (otherwise it will be
modified sensibly to fit in that range), or a named logging level
(one of \Sexpr{paste0('"', log4r:::LEVEL_NAMES, '"', collapse = ", ")}).
An object of class loglevel is also accepted; other input will be coerced
using \code{\link{as.loglevel}}.
}
\examples{
library('log4r')

logger <- create.logger(logfile = 'debugging.log', level = 1)
level(logger)
level(logger) <- "FATAL"
}
\seealso{
\code{\link{loglevel}}
}

