% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RegkoPanel}
\alias{RegkoPanel}
\title{Korean regional panel data (2014-2016)}
\format{
A data frame with 792 rows of 24 variables:
\describe{
  \item{id}{ID of region}
  \item{metro}{Metropolitan region name (metro cities and provinces)}
  \item{region}{Region name}
  \item{type}{1=si (non-metropolitan cities), 2=gun, 3=gu in metro cities and provinces}
  \item{year}{Year}
  \item{grdp}{gross regional GDP}
  \item{regpop}{population}
  \item{popgrowth}{population growth (=100*(regpop/regpop[-1]-1))}
  \item{eq5d}{the EQ-5D health index}
  \item{deaths}{number of deaths}
  \item{drink}{\% of drinkers}
  \item{hdrink}{\% of high-risk drinkers}
  \item{smoke}{\% of smokers}
  \item{aged}{\% of aged 65 and over}
  \item{divorce}{# of divorces per 1000 pop}
  \item{medrate}{# of medical beds per 1000 pop}
  \item{gcomp}{gender composition # men / 100 women}
  \item{vehipc}{# of vehicles per person}
  \item{accpv}{# of accidents per 1000 vehicles}
  \item{dumppc}{waste dump per person, kg/day}
  \item{stratio}{# of students per teacher}
  \item{deathrate}{# of deaths per 100,000 pop}
  \item{pctmale}{=gcmp/(gcomp+100)*100, \% of male}
  \item{accpc}{=vehipc*accpv, # of accidents per 1000 pop}
}
}
\source{
\url{http://kostat.go.kr/}
}
\usage{
data(RegkoPanel)
}
\description{
Korean regional panel data (2014-2016)
}
\author{
\packageAuthor{loedata}
}
\keyword{datasets}
