% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetrack_ly.R
\name{genetrack_ly}
\alias{genetrack_ly}
\title{Gene tracks using 'plotly'}
\usage{
genetrack_ly(
  locus,
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  cex.text = 0.7,
  gene_col = ifelse(showExons, "blue4", "skyblue"),
  exon_col = "blue4",
  exon_border = "blue4",
  showExons = TRUE,
  maxrows = 8,
  width = 600,
  xlab = NULL,
  blanks = c("fill", "hide", "show"),
  height = NULL,
  plot = TRUE
)
}
\arguments{
\item{locus}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons (or genes if
\code{showExons} is \code{FALSE}). Set to \code{NA} for no border.}

\item{showExons}{Logical whether to show exons or simply show whole gene as a
rectangle. If \code{showExons = FALSE} colours are specified by \code{exon_border}
for rectangle border and \code{gene_col} for the fill colour.}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{width}{Width of plotly plot in pixels which is purely used to prevent
overlapping text for gene names.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified
in \code{locus}.}

\item{blanks}{Controls handling of genes with blank names: \code{"fill"} replaces
blank gene symbols with ensembl gene ids. \code{"hide"} completely hides genes
which are missing gene symbols. \code{"show"} shows gene lines but no label
(hovertext is still available).}

\item{height}{Height in pixels (optional, defaults to automatic sizing).}

\item{plot}{Logical whether to produce plotly object or return plot
coordinates.}
}
\value{
Either a 'plotly' plotting object showing gene tracks, or if
\code{plot = FALSE} a list containing \code{TX}, a dataframe of coordinates for
gene transcripts, and \code{EX}, a dataframe of coordinates for exons.
}
\description{
Plot gene annotation tracks from \code{ensembldb} data using \code{plotly}.
}
\details{
This function can used to plot gene annotation tracks on their own.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'UBE2L3', flank = 1e5,
             ens_db = "EnsDb.Hsapiens.v75")
genetrack_ly(loc)
}
}
