% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{sequences2transmatrix}
\alias{sequences2transmatrix}
\title{Transition matrix from sequence(s)}
\usage{
sequences2transmatrix(sequences)
}
\arguments{
\item{sequences}{Sequences to be analyzed, as list of numeric vectors}
}
\value{
A list object containing
\item{Transition Matrix}{Transition Matrix}
\item{Min Value}{minimal score found in supplied sequences}
\item{Max Value}{maximal score found in supplied sequences}
}
\description{
Calculates the transition matrix by counting occurences of tuples in given vector list
}
\details{
The transition matrix will be structured so that the lowest score corresponds to the first column and row
and the highest score corresponds to the last column and row. Note that the resulting matrix is not stochastic because it can occur rows filled up with only 0 for not observed score in Min Value Max Value interval.
}
\examples{
seq = sample(-1:1, size = 20, replace = TRUE)
seq2 = sample(-6:1, size = 20, replace = TRUE)
seq3 = sample(3:6, size = 50, replace = TRUE)
sequences2transmatrix(list(seq, seq2, seq3))
}
