% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{monteCarlo}
\alias{monteCarlo}
\title{Monte Carlo method [p-value]}
\usage{
monteCarlo(local_score, FUN, ..., plot = TRUE, numSim = 1000)
}
\arguments{
\item{local_score}{local score observed in a segment.}

\item{FUN}{function to simulate similar sequences with.}

\item{...}{parameters for FUN}

\item{plot}{boolean value if to display plots for cumulated function and density}

\item{numSim}{number of sequences to generate during simulation}
}
\value{
Floating value corresponding to the probability to obtain a local score with value greater or equal to the parameter
}
\description{
Calculates an empirical p-value based on simulations of similar integer sequences of the same length.
Perfect for small sequences (both markov chains and identically and independantly distributed) with length ~ 10^3. 
See function monteCarlo_double() for possible real scores.
}
\examples{
\donttest{
monteCarlo(120, FUN = rbinom, n = 100, size = 5, prob=0.2)
}
new = sample(-7:6, replace = TRUE, size = 1000)
#MonteCarlo taking random sample from the input sequence itself
\donttest{
monteCarlo(local_score = 20, FUN = function(x) {return(sample(x = x, 
size = length(x), replace = TRUE))}, x=new)
}
# Markovian example
MyTransMat <-
+     matrix(c(0.3,0.1,0.1,0.1,0.4, 0.2,0.2,0.1,0.2,0.3, 0.3,0.4,0.1,0.1,0.1, 0.3,0.3,0.1,0.0,0.3,
+              0.1,0.1,0.2,0.3,0.3), ncol = 5, byrow=TRUE)
\donttest{
monteCarlo(local_score = 50,
          FUN = transmatrix2sequence, matrix = MyTransMat,
          length=150, score = c(-2,-1,0,2,3), plot=FALSE, numSim = 5000)
}
}
