% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{localScoreC_double}
\alias{localScoreC_double}
\title{Local score for sequences of floating values}
\usage{
localScoreC_double(v, supressWarnings = FALSE)
}
\arguments{
\item{v}{A sequence of values as vector.}

\item{supressWarnings}{if warnings should be displayed}
}
\value{
A structure containing: the local score value and the begin and end index of the segment realizing this optimal score ; all the local maxima of the Lindley process (non negative excursion) and their begin and ens index ; the record times of the Lindley process but only the ones corresponding to the begin index of non negative excursions
}
\description{
Calculates the local score for a sequence of doubles. Only provides the
first occurrence. Use function suboptimalSegment() or Lindley() to obtain the others localizations of the different realizations of the local score.
}
\examples{
localScoreC_double(c(1.2,-2.1,3.5,1.7,-1.1,2.3))
seq.TwoSegments=c(1.2,-2.1,3.5,1.7,2,-2,-2,-3.5,1,3.5,1.7,1,-2,-2)
# two segments realizing the local score value
localScoreC(seq.TwoSegments) 
# only the first realization
localScoreC(seq.TwoSegments)$localScore 
# all the realization of the local together with the suboptimal ones
localScoreC(seq.TwoSegments)$suboptimalSegmentScores 
# for small sequences, you can also use lindley() fonction to check if 
# several segments achieve the local score
lindley(seq.TwoSegments) 
plot(1:length(seq.TwoSegments),lindley(seq.TwoSegments),type='b')
seq.TwoSegments.InSameExcursion=c(1,-2,3,2,-1,0,1,-2,-2)
localScoreC(seq.TwoSegments.InSameExcursion)
# lindley() shows two realizations in the same excursion (no 0 value between the two LS values)
lindley(seq.TwoSegments.InSameExcursion) 
plot(1:length(seq.TwoSegments.InSameExcursion),lindley(seq.TwoSegments.InSameExcursion),type='b')
# same beginning index but two possible ending indexes
# only one excursion realizes the local score even in there is two possible length of segment
localScoreC(seq.TwoSegments.InSameExcursion)$suboptimalSegmentScores 
}
