% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{get_lib_path}
\alias{get_lib_path}
\title{Get Backend Library Path}
\usage{
get_lib_path()
}
\value{
Character string containing the path to the backend library file.
}
\description{
Returns the full path to the installed localLLM backend library.
}
\details{
This function will throw an error if the backend library is not installed.
  Use \code{\link{lib_is_installed}} to check installation status first.
}
\examples{
\dontrun{
# Get the library path (only if installed)
if (lib_is_installed()) {
  lib_path <- get_lib_path()
  message("Library is at: ", lib_path)
}
}
}
\seealso{
\code{\link{lib_is_installed}}, \code{\link{install_localLLM}}
}
