\name{DT_wheat}
\alias{DT_wheat}
\alias{GT_wheat}
\title{wheat lines dataset}
\description{

Information from a collection of 599 historical CIMMYT wheat lines.  The wheat data set is from 
CIMMYT's Global Wheat Program. Historically, this program has conducted numerous international 
trials across a wide variety of wheat-producing environments. The environments represented in 
these trials were grouped into four basic target sets of environments comprising four 
main agroclimatic regions previously defined and widely used by CIMMYT's Global Wheat Breeding Program. 
The phenotypic trait considered here was the average grain yield (GY) of the 599 wheat lines evaluated 
in each of these four mega-environments. 

A pedigree tracing back many generations was available, and the Browse application of 
the International Crop Information System (ICIS), as described in  (McLaren \emph{et al.} 2000, 2005) was used 
for deriving the relationship matrix A among the 599 lines; it accounts for selection and inbreeding.

Wheat lines were recently genotyped using 1447 Diversity Array Technology (DArT) generated by 
Triticarte Pty. Ltd. (Canberra, Australia; http://www.triticarte.com.au). The DArT markers 
may take on two values, denoted by their presence or absence. Markers with a minor allele frequency 
lower than 0.05 were removed, and missing genotypes were imputed with samples from the marginal 
distribution of marker genotypes, that is, \eqn{x_{ij}=Bernoulli(\hat p_j)}, where  \eqn{\hat p_j}  
is the estimated allele frequency computed from the non-missing genotypes. The number of DArT 
MMs after edition was 1279.

}

\usage{
  data(DT_wheat)
}

\format{
 Matrix Y contains the average grain yield, column 1: Grain yield for environment 1 and so on. 
}

\source{
  International Maize and Wheat Improvement Center (CIMMYT), Mexico.
}

\references{

Giovanny Covarrubias-Pazaran (2024).  lme4breeding: enabling genetic evaluation in the age of genomic data. To be submitted to Bioinformatics.

Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48.

McLaren, C. G., L. Ramos, C. Lopez, and W. Eusebio. 2000. ``Applications of the geneaology manegment system.'' 
In \emph{International Crop Information System. Technical  Development Manual, version VI}, edited by McLaren, C. G., J.W. White 
and P.N. Fox. pp. 5.8-5.13. CIMMyT, Mexico: CIMMyT and IRRI. 

McLaren, C. G., R. Bruskiewich, A.M. Portugal, and A.B. Cosico. 2005. The International Rice Information System. 
A platform for meta-analysis of rice crop data. \emph{Plant Physiology} \bold{139}: 637-642.

}
\examples{

data(DT_wheat)
DT <- DT_wheat
GT <- GT_wheat
DT <- data.frame(pheno=as.vector(DT),
                 env=as.factor(paste0("e", sort(rep(1:4,nrow(DT))))),
                 id=rep(rownames(DT),4))

rownames(GT) <-  rownames(DT_wheat)
K <- A.mat(GT) # additive relationship matrix
K[1:4,1:4]
##
head(DT)

\donttest{

#### univariate model
mix0 <- lmebreed(pheno ~ (1|id),
                 relmat = list(id=K),
                 control = lmerControl(
                   check.nobs.vs.nlev = "ignore",
                   check.nobs.vs.rankZ = "ignore",
                   check.nobs.vs.nRE="ignore"
                 ),
                 data=DT)
vc <- VarCorr(mix0); print(vc,comp=c("Variance"))

}

}
\keyword{datasets}
\seealso{The core function of the package \code{\link{lmebreed}} }
