% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_type_code}
\alias{get_type_code}
\title{Extract Litter Code}
\usage{
get_type_code(x)
}
\arguments{
\item{x}{\code{character} vector containg litter codes}
}
\value{
litter code (\code{character} vector).
}
\description{
Extract litter codes (ASCII characters in square brackets) from character
vector \code{x}.
}
\examples{
# valid litter type
stopifnot(get_type_code("Plastic: Food [6]") == "[6]")
stopifnot(get_type_code(c("Plastic: Food [6]", "Plastic: Shoes [44]")) == c("[6]", "[44]"))

# invalid litter type: additional punctuation : and + are not allowed
stopifnot(is.na(get_type_code("All cartons/tetrapaks [302:204+62+118]")))
stopifnot(is.na(get_type_code("[TA]")))
}
