% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bliteMethods.R
\name{bliteMethods}
\alias{bliteMethods}
\alias{plot.blite}
\alias{coef.blite}
\alias{vcov.blite}
\alias{nobs.blite}
\alias{summary.blite}
\alias{print.summary.blite}
\alias{confint.blite}
\title{Methods for objects of class \code{"blite"}}
\usage{
\method{plot}{blite}(x, which = c("all", "pu", "gp", "xi", "theta"), ...)

\method{coef}{blite}(object, fun, ...)

\method{vcov}{blite}(object, ...)

\method{nobs}{blite}(object, ...)

\method{summary}{blite}(
  object,
  short = TRUE,
  mean = TRUE,
  digits = max(3, getOption("digits") - 3L),
  ...
)

\method{print}{summary.blite}(x, ...)

\method{confint}{blite}(object, parm = "all", level = 0.95, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"blite"}, a result of a
call to \code{\link{blite}}.}

\item{which}{A character scalar indicating which plot(s) to produce.
If \code{which = "all"} then all 4 plots described in \strong{Details}
are produced.  Otherwise, only one of these plots is produced, with the
possible names of the arguments being in the order that the plots are
described in \strong{Details}.}

\item{...}{For \code{plot.blite}: arguments passed to
  \code{\link[graphics:plot.default]{plot}}, such as graphical parameters.

  For \code{coef.blite}: additional arguments passed to \code{fun}.

  For \code{print.summary.blite}: additional arguments passed to
  \code{\link{print.default}}.

  Otherwise \code{...} is unused.}

\item{object}{An object of class \code{"blite"}, returned by
\code{\link{blite}}.}

\item{fun}{A summary function to be applied to each column of the simulated
values in \code{object}.  If \code{fun} is missing then
\code{\link[base]{mean}} is used.}

\item{short}{A logical scalar that determines the form of the output. See
\strong{Details}.}

\item{mean}{A logical scalar.  Determines the form of the output if
\code{short = TRUE}. See \strong{Details}.}

\item{digits}{An integer. Passed to \code{\link[base:Round]{signif}} to
round the values in the summary.}

\item{parm}{A character vector specifying the parameters for which
confidence intervals are required. The default, \code{which = "all"},
produces confidence intervals for all the parameters, that is,
\ifelse{html}{\eqn{p}\out{<sub>u</sub>}}{\eqn{p_u}},
\ifelse{html}{\eqn{\sigma}\out{<sub>u</sub>}}{\eqn{\sigma_u}},
\eqn{\xi} and \eqn{\theta}. If \code{which = "gp"} then intervals are
produced only for
\ifelse{html}{\eqn{\sigma}\out{<sub>u</sub>}}{\eqn{\sigma_u}} and
\eqn{\xi}. Otherwise, \code{parm} must be a subset of
\code{c("pu", "sigmau", "xi", "theta")}.}

\item{level}{The credible level required.  A numeric scalar in (0, 1).}
}
\value{
\code{plot.blite}: No return value, only the plot is produced.

  \code{coef.blite}: a numeric vector of length 4 with names
    \code{c("p[u]", "sigma[u]", "xi", "theta")}.  The values of summary
    statistics calculated using the function \code{fun}.

  \code{vcov.blite}: a \eqn{4 \times 4}{4 x 4} matrix with row and
    column names \code{c("p[u]", "sigma[u]", "xi", "theta")}.  An estimate
    of the posterior covariance matrix, calculated using
    \code{\link[stats]{cov}}.

  \code{nobs.blite}: a numeric vector of length 3 with names
    \code{c("p[u]", "gp", "theta")}.  The respective number of observations
    used to infer \ifelse{html}{\eqn{p}\out{<sub>u</sub>}}{\eqn{p_u}},
    (\ifelse{html}{\eqn{\sigma}\out{<sub>u</sub>}}{\eqn{\sigma_u}},
    \eqn{\xi}) and \eqn{\theta}.

  \code{summary.blite}: an object containing the original function call and
    a matrix of summaries of the posterior samples for each of the
    parameters.  If \code{short = TRUE} then there are 2 columns, containing
    either the sample posterior means and standard deviations
    (\code{mean = TRUE}) or the sample posterior medians and inter-quartile
    ranges (\code{mean = FALSE}).  If \code{short = FALSE} then there are 4
    columns, with each column containing the usual 6-number summary produced
    by \code{\link[base]{summary}}. The object is printed by
    \code{\link{print.summary.blite}}.

  \code{print.summary.blite}: the argument \code{x} is returned, invisibly.

  \code{confint.blite}: a numeric matrix with 2 columns giving the lower and
    upper credible limits for each parameter. These columns are labelled
    as \code{(1-level)/2} and \code{1-(1-level)/2}, expressed as a
    percentage, by default \code{2.5\%} and \code{97.5\%}.  The row names
    are the names of the parameters supplied in \code{parm}.
}
\description{
Methods for objects of class \code{"blite"} returned from
\code{\link{blite}}. \code{confint.blite} is a misnomer: it returns
(equi-tailed) Bayesian credible intervals.
}
\details{
For \code{plot.blite}, if \code{which = "all"} then 4 plots are produced.
    \itemize{
      \item{Top left: histogram of the posterior sample for the threshold
        exceedance probability
        \ifelse{html}{\eqn{p}\out{<sub>u</sub>}}{\eqn{p_u}}.}
      \item{Top right: scatter plot of posterior sample for the GP
        parameters
        (\ifelse{html}{\eqn{\sigma}\out{<sub>u</sub>}}{\eqn{\sigma_u}},
        \eqn{\xi}).
        The linear constraint
        \ifelse{html}{\eqn{\xi} > -\eqn{\sigma}\out{<sub>u</sub>} / \eqn{x}
        \out{<sub>(n)</sub>}}{\eqn{\xi > -\sigma_u / x_{(n)}}}
        is drawn on the plot.}
      \item{Bottom left: histogram of the posterior sample for the GP shape
        parameter \eqn{\xi}.}
      \item{Bottom right: histogram of the posterior sample for the extremal
        index \eqn{\theta}.}
    }
}
\seealso{
\code{\link{blite}} to perform frequentist threshold-based
  inference for time series extremes.

\code{\link{predict.blite}}: for predictive inference for the
  largest value observed in \eqn{N} years.
}
