% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-yml.r
\name{as_ld_yml}
\alias{as_ld_yml}
\title{Turn a Computational Component List into YAML with Class Information}
\usage{
as_ld_yml(x)
}
\arguments{
\item{x}{a named list of computational components.}
}
\description{
Create an object of type yaml::yml from a list of
computational components. The function recursively descends into the list
and when an element type is not a list the class information substituted
for the object.
}
\examples{
if (require("ggplot2")) {

  cc_list <- list(
    Linear = ggplot(anscombe, aes(x = x1, y = y1)) + geom_point(),
   `Non Linear` = ggplot(anscombe, aes(x = x2, y = y2)) + geom_point(),
   `Outlier Vertical`= ggplot(anscombe, aes(x = x3, y = y3)) + geom_point(),
   `Outlier Horizontal` =  ggplot(anscombe, aes(x = x4, y = y4)) +
     geom_point())

  as_ld_yml(cc_list)
}
}
