% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{exSVM}
\alias{exSVM}
\alias{svmExpectileRegression}
\title{Expectile Regression}
\usage{
exSVM(x, y, ..., weights = c(0.05, 0.1, 0.5, 0.9, 0.95), clipping = -1,
  do.select = TRUE)

svmExpectileRegression(x, y, ..., weights = c(0.05, 0.1, 0.5, 0.9, 0.95),
  clipping = -1, do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{weights}{the expectiles that should be estimated}

\item{clipping}{absolute value where the estimated labels will be clipped. -1 (the default)
leads to an adaptive clipping value, whereas 0 disables clipping.}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine performs non-parametric, asymmetric least squares 
regression using SVMs. The tested estimators are therefore estimating 
the conditional tau-expectiles of Y given X. By default, estimators
for five different tau values are computed.
\code{svmExpectileRegression} is a simple alias of \code{exSVM}.
}
\examples{
\dontrun{
tt <- ttsplit(quakes)
model <- exSVM(mag~., tt$train, display=1)
result <- test(model, tt$test)

errors(result)[2] ## is the same as
mean(ifelse(result[,2]<tt$test$mag, .1,.9) * (result[,2]-tt$test$mag)^2)
}
}
