% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commas_linter.R
\name{commas_linter}
\alias{commas_linter}
\title{Commas linter}
\usage{
commas_linter(allow_trailing = FALSE)
}
\arguments{
\item{allow_trailing}{If \code{TRUE}, the linter allows a comma to be followed
directly by a closing bracket without a space.}
}
\description{
Check that all commas are followed by spaces, but do not have spaces before them.
}
\examples{
# will produce lints
lint(
  text = "switch(op , x = foo, y = bar)",
  linters = commas_linter()
)

lint(
  text = "mean(x,trim = 0.2,na.rm = TRUE)",
  linters = commas_linter()
)

lint(
  text = "x[ ,, drop=TRUE]",
  linters = commas_linter()
)

lint(
  text = "x[1,]",
  linters = commas_linter()
)

# okay
lint(
  text = "switch(op, x = foo, y = bar)",
  linters = commas_linter()
)

lint(
  text = "switch(op, x = , y = bar)",
  linters = commas_linter()
)

lint(
  text = "mean(x, trim = 0.2, na.rm = TRUE)",
  linters = commas_linter()
)

lint(
  text = "a[1, , 2, , 3]",
  linters = commas_linter()
)

lint(
  text = "x[1,]",
  linters = commas_linter(allow_trailing = TRUE)
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#commas}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
