% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_combine_linter.R
\name{inner_combine_linter}
\alias{inner_combine_linter}
\title{Require c() to be applied before relatively expensive vectorized functions}
\usage{
inner_combine_linter()
}
\description{
\code{as.Date(c(a, b))} is logically equivalent to \code{c(as.Date(a), as.Date(b))};
ditto for the equivalence of several other vectorized functions like
\code{\link[=as.POSIXct]{as.POSIXct()}} and math functions like \code{\link[=sin]{sin()}}. The former is to be
preferred so that the most expensive part of the operation (\code{\link[=as.Date]{as.Date()}})
is applied only once.
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
