% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brace_linter.R
\name{brace_linter}
\alias{brace_linter}
\title{Brace linter}
\usage{
brace_linter(allow_single_line = FALSE)
}
\arguments{
\item{allow_single_line}{if \code{TRUE}, allow an open and closed curly pair on the same line.}
}
\description{
Perform various style checks related to placement and spacing of curly braces:
}
\details{
\itemize{
\item Opening curly braces are never on their own line and are always followed by a newline.
\item Opening curly braces have a space before them.
\item Closing curly braces are on their own line unless they are followed by an \verb{else}.
\item Closing curly braces in \code{if} conditions are on the same line as the corresponding \verb{else}.
\item Either both or neither branch in \code{if}/\verb{else} use curly braces, i.e., either both branches use \code{{...}} or neither
does.
\item Functions spanning multiple lines use curly braces.
}
}
\seealso{
\link{linters} for a complete list of linters available in lintr. \cr
\url{https://style.tidyverse.org/syntax.html#indenting} \cr
\url{https://style.tidyverse.org/syntax.html#if-statements}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
