% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagaControl.R
\name{findSAGA}
\alias{findSAGA}
\title{Search recursivly existing 'SAGA GIS' installation(s) at a given drive/mountpoint}
\usage{
findSAGA(searchLocation = "default", quiet = TRUE)
}
\arguments{
\item{searchLocation}{drive letter to be searched, for Windows systems default
is \code{C:}, for Linux systems default is \code{/usr}.}

\item{quiet}{boolean  switch for supressing messages default is TRUE}
}
\value{
A dataframe with the 'SAGA GIS' root folder(s), version name(s) and 
installation type code(s)
}
\description{
Provides an  list of valid 'SAGA GIS' installation(s) 
on your 'Windows' system. There is a major difference between osgeo4W and 
stand_alone installations. The functions trys to find all valid 
installations by analysing the calling batch scripts.
}
\examples{
\dontrun{
# find recursively all existing 'SAGA GIS' installation folders starting 
# at the default search location
findSAGA()
}
}
\author{
Chris Reudenbach
}
