% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPutils.R
\name{bounds2lineqSys}
\alias{bounds2lineqSys}
\title{Linear Systems of Inequalities}
\usage{
bounds2lineqSys(
  d = nrow(A),
  l = 0,
  u = 1,
  A = diag(d),
  lineqSysType = "twosides",
  rmInf = TRUE
)
}
\arguments{
\item{d}{the number of linear inequality constraints.}

\item{l}{the value (or vector) with the lower bound.}

\item{u}{the value (or vector) with the upper bound.}

\item{A}{a matrix containing the structure of the linear equations.}

\item{lineqSysType}{a character string corresponding to the type of the
linear system. Options: \code{twosides}, \code{oneside}. \cr
    - \code{twosides} : Linear system given by
      \deqn{\boldsymbol{l} \leq \boldsymbol{A x} \leq \boldsymbol{u}.}{l \le A x \le u.}

    - \code{oneside} : Extended linear system given by
      \deqn{\boldsymbol{M x} + \boldsymbol{g} \geq \boldsymbol{0} \quad \mbox{with} \quad \boldsymbol{M} = [\boldsymbol{A}, -\boldsymbol{A}]^\top \quad \mbox{and} \quad \boldsymbol{g} = [-\boldsymbol{l}, \boldsymbol{u}]^\top.}{M x + g \ge 0 with M = [A, -A]^T and g = [-l, u]^T.}}

\item{rmInf}{If \code{TRUE}, inactive constraints are removed
(e.g. \eqn{-\infty \leq x \leq \infty}{-Inf \le x \le Inf}).}
}
\value{
A list with the linear system of inequalities:
\code{list(A,l,u)} (\code{twosides}) or \code{list(M,g)} (\code{oneside}).
}
\description{
Build the linear system of inequalities given specific bounds.
}
\examples{
n <- 5
A <- diag(n)
l <- rep(0, n)
u <- c(Inf, rep(1, n-1))
bounds2lineqSys(n, l, u, A, lineqSysType = "twosides")
bounds2lineqSys(n, l, u, A, lineqSysType = "oneside", rmInf = FALSE)
bounds2lineqSys(n, l, u, A, lineqSysType = "oneside", rmInf = TRUE)

}
\author{
A. F. Lopez-Lopera.
}
