% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_expected.R
\name{mergeMeasMeta}
\alias{mergeMeasMeta}
\title{Merge measurements and metadata}
\usage{
mergeMeasMeta(y, metadata, features = NULL, sampleColname = "sample")
}
\arguments{
\item{y}{Matrix-like object of measurements, with rows corresponding to
features and columns to samples.}

\item{metadata}{data.frame containing experimental design information for
each sample. Rows of \code{metadata} must correspond to columns of \code{y}. Row
names are ignored.}

\item{features}{Vector of names, row numbers, or logical values for
subsetting the features. \code{NULL} indicates all features.}

\item{sampleColname}{String indicating the column in \code{metadata} containing
the name of each sample, which must correspond to the column names of \code{y}.}
}
\value{
A \code{data.table} with one row for each sample-feature pair.
}
\description{
This function is useful for plotting time-courses for individual features.
}
\examples{
library('data.table')

y = GSE34018$y
metadata = GSE34018$metadata

fit = getModelFit(y, metadata)
fit = getPosteriorFit(fit)

measObs = mergeMeasMeta(y, metadata, features = c('13170', '12686'))
measFitMean = getExpectedMeas(
  fit, times = seq(0, 24, 0.5), features = c('13170', '12686'))
}
\seealso{
\code{\link[=getExpectedMeas]{getExpectedMeas()}}
}
